/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HttpUtils {
    private static Map<Executor, URI> executors = new HashMap<Executor, URI>();
    public static IProxyService proxyService = HttpUtils.getProxyService();
    public static String USER_AGENT_JASPERSOFT_STUDIO = "JaspersoftStudio";
    public static final String USER_AGENT = "com.jaspersoft.studio.server.user-agent";

    public static String getProxyProtocol(IProxyData d) {
        String protocol = d.getType().toLowerCase();
        if (protocol.equals("https")) {
            protocol = "http";
        }
        return protocol;
    }

    public static HttpClientBuilder setupProxy(HttpClientBuilder clientBuilder) {
        BasicCredentialsProvider cp = new BasicCredentialsProvider();
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)cp);
        HttpRoutePlanner routePlanner = new HttpRoutePlanner((CredentialsProvider)cp){
            private final /* synthetic */ CredentialsProvider val$cp;
            {
                this.val$cp = credentialsProvider;
            }

            public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
                InetAddress local = RequestConfig.DEFAULT.getLocalAddress();
                boolean secure = "https".equalsIgnoreCase(target.getSchemeName());
                try {
                    IProxyData[] iProxyDataArray = proxyService.select(new URI(target.toURI()));
                    if (iProxyDataArray.length != 0) {
                        IProxyData d = iProxyDataArray[0];
                        Credentials c = HttpUtils.getCredentials(d);
                        if (c != null) {
                            this.val$cp.setCredentials(new AuthScope(d.getHost(), d.getPort()), c);
                        }
                        return new HttpRoute(target, local, new HttpHost(d.getHost(), d.getPort(), HttpUtils.getProxyProtocol(d)), secure);
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                return new HttpRoute(target, local, secure);
            }
        };
        clientBuilder.setRoutePlanner(routePlanner);
        return clientBuilder;
    }

    public static Executor setupProxy(Executor exec, URI uri) {
        if (uri.getHost() == null) {
            return exec;
        }
        IProxyData[] iProxyDataArray = proxyService.select(uri);
        if (iProxyDataArray.length != 0) {
            IProxyData d = iProxyDataArray[0];
            Credentials c = HttpUtils.getCredentials(d);
            if (c != null) {
                exec.auth(new HttpHost(d.getHost(), d.getPort()), c);
            }
            exec.authPreemptiveProxy(new HttpHost(d.getHost(), d.getPort(), HttpUtils.getProxyProtocol(d)));
        }
        executors.put(exec, uri);
        return exec;
    }

    public static void setupProxy(Executor exec, URI uri, Request req) {
        HttpHost proxy = HttpUtils.getUnauthProxy(exec, uri);
        if (proxy != null) {
            req.viaProxy(proxy);
        }
    }

    public static HttpHost getUnauthProxy(Executor exec, URI uri) {
        IProxyData[] iProxyDataArray = proxyService.select(uri);
        int n = iProxyDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData d = iProxyDataArray[n2];
            Credentials c = HttpUtils.getCredentials(d);
            if (c == null) {
                return new HttpHost(d.getHost(), d.getPort(), HttpUtils.getProxyProtocol(d));
            }
            ++n2;
        }
        return null;
    }

    public static IProxyService getProxyService() {
        BundleContext bc = JasperReportsPlugin.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bc.getServiceReference(IProxyService.class.getName());
        IProxyService service = (IProxyService)bc.getService(serviceReference);
        service.addProxyChangeListener(new IProxyChangeListener(){

            public void proxyInfoChanged(IProxyChangeEvent event) {
                for (Executor exe : executors.keySet()) {
                    HttpUtils.setupProxy(exe, executors.get(exe));
                }
            }
        });
        return service;
    }

    public static Credentials getCredentials(IProxyData data) {
        String userId = data.getUserId();
        if (userId != null) {
            UsernamePasswordCredentials proxyCred = new UsernamePasswordCredentials(userId, data.getPassword());
            int domainIndex = userId.indexOf("\\");
            if (domainIndex > 0) {
                String domain = userId.substring(0, domainIndex);
                if (userId.length() > domainIndex + 1) {
                    String user = userId.substring(domainIndex + 1);
                    proxyCred = new NTCredentials(user, data.getPassword(), data.getHost(), domain);
                }
            }
            return proxyCred;
        }
        return null;
    }
}

