/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.eclipse.viewer.IReportViewerListener;
import net.sf.jasperreports.eclipse.viewer.ReportViewerEvent;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import net.sf.jasperreports.renderers.AreaHyperlinksRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.wb.swt.Keyboard;

public class ViewerCanvas
extends Canvas {
    public static final int ZOOM_MODE_NONE = 0;
    public static final int ZOOM_MODE_ACTUAL_SIZE = 1;
    public static final int ZOOM_MODE_FIT_WIDTH = 2;
    public static final int ZOOM_MODE_FIT_HEIGHT = 3;
    public static final int ZOOM_MODE_FIT_PAGE = 4;
    public static final int MARGIN = 5;
    private static final Cursor CURSOR_SIZEALL = new Cursor(null, 5);
    private static final Cursor CURSOR_HAND = new Cursor(null, 21);
    private JRPrintPage page;
    private List<IHyperlinkContainer> links = new ArrayList<IHyperlinkContainer>();
    private Image reportImage;
    private String errorMessage;
    private boolean dragging;
    private JRPrintHyperlink currentLink;
    private org.eclipse.swt.graphics.Rectangle ds;
    private IReportViewer rViewer;
    private MouseListener mListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
            if (ViewerCanvas.this.reportImage != null) {
                if (ViewerCanvas.this.dragging) {
                    ViewerCanvas.this.dragging = false;
                    ViewerCanvas.this.setCursor(null);
                }
                if (e.button == 1 && ViewerCanvas.this.currentLink != null && ViewerCanvas.this.currentLink == ViewerCanvas.this.getHyperlinkAt(e.x, e.y)) {
                    ViewerCanvas.this.setCursor(null);
                    try {
                        BusyIndicator.showWhile((Display)ViewerCanvas.this.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ViewerCanvas.this.handleHyperlinkClick();
                            }
                        });
                    }
                    finally {
                        ViewerCanvas.this.setCursor(CURSOR_HAND);
                    }
                }
                if (ViewerCanvas.this.reportImage != null) {
                    ViewerCanvas.this.updateHyperlink(e.x, e.y);
                } else {
                    ViewerCanvas.this.currentLink = null;
                    ViewerCanvas.this.setCursor(null);
                }
            }
        }

        public void mouseDown(MouseEvent e) {
            if (ViewerCanvas.this.reportImage != null && e.button == 1 && ViewerCanvas.this.currentLink == null) {
                ViewerCanvas.this.dragging = true;
                ViewerCanvas.this.ds = new org.eclipse.swt.graphics.Rectangle(e.x, e.y, ViewerCanvas.this.getVerticalBar().getSelection(), ViewerCanvas.this.getHorizontalBar().getSelection());
                ViewerCanvas.this.setCursor(CURSOR_SIZEALL);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };
    private MouseMoveListener mMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            if (ViewerCanvas.this.reportImage != null) {
                if (ViewerCanvas.this.dragging) {
                    ViewerCanvas.this.setScrollBarSelection(ViewerCanvas.this.getHorizontalBar(), ViewerCanvas.this.ds.height - e.x + ViewerCanvas.this.ds.x);
                    ViewerCanvas.this.setScrollBarSelection(ViewerCanvas.this.getVerticalBar(), ViewerCanvas.this.ds.width - e.y + ViewerCanvas.this.ds.y);
                    ViewerCanvas.this.repaint();
                } else {
                    ViewerCanvas.this.updateHyperlink(e.x, e.y);
                }
            }
        }
    };
    private PaintListener pListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            ViewerCanvas.this.paint(e.gc);
        }
    };
    private KeyListener keyListener = new KeyListener(){

        private int setDecrementSelection(ScrollBar sb) {
            int s = sb.getSelection();
            ViewerCanvas.this.setScrollBarSelection(sb, s - sb.getIncrement());
            return s;
        }

        private int setIncrementSelection(ScrollBar sb) {
            int s = sb.getSelection();
            ViewerCanvas.this.setScrollBarSelection(sb, s + sb.getIncrement());
            return s;
        }

        public void keyReleased(KeyEvent e) {
            if ((e.stateMask & Keyboard.getCtrlKey()) != 0) {
                switch (e.keyCode) {
                    case 43: 
                    case 61: 
                    case 16777259: {
                        ViewerCanvas.this.zoomIn();
                        ViewerCanvas.this.repaint();
                        break;
                    }
                    case 48: 
                    case 0x1000030: {
                        ViewerCanvas.this.setZoom(1.0f);
                        break;
                    }
                    case 45: 
                    case 16777261: {
                        ViewerCanvas.this.zoomOut();
                    }
                }
            } else {
                switch (e.keyCode) {
                    case 0x1000001: 
                    case 0x1000005: {
                        ScrollBar sb = ViewerCanvas.this.getVerticalBar();
                        if (sb.getSelection() == this.setDecrementSelection(sb)) {
                            if (!ViewerCanvas.this.rViewer.canGotoPreviousPage()) break;
                            ViewerCanvas.this.rViewer.gotoPreviousPage();
                            ViewerCanvas.this.setScrollBarSelection(sb, sb.getMaximum());
                            ViewerCanvas.this.repaint();
                            break;
                        }
                        ViewerCanvas.this.repaint();
                        break;
                    }
                    case 0x1000002: 
                    case 0x1000006: {
                        ScrollBar sb = ViewerCanvas.this.getVerticalBar();
                        if (sb.getSelection() == this.setIncrementSelection(sb)) {
                            if (!ViewerCanvas.this.rViewer.canGotoNextPage()) break;
                            ViewerCanvas.this.rViewer.gotoNextPage();
                            ViewerCanvas.this.setScrollBarSelection(sb, sb.getMinimum());
                            ViewerCanvas.this.repaint();
                            break;
                        }
                        ViewerCanvas.this.repaint();
                        break;
                    }
                    case 0x1000003: {
                        this.setDecrementSelection(ViewerCanvas.this.getHorizontalBar());
                        ViewerCanvas.this.repaint();
                        break;
                    }
                    case 0x1000004: {
                        this.setIncrementSelection(ViewerCanvas.this.getHorizontalBar());
                        ViewerCanvas.this.repaint();
                        break;
                    }
                    case 0x1000007: {
                        if (ViewerCanvas.this.rViewer.canGotoFirstPage()) {
                            ViewerCanvas.this.rViewer.gotoFirstPage();
                        }
                        ScrollBar sb = ViewerCanvas.this.getVerticalBar();
                        ViewerCanvas.this.setScrollBarSelection(sb, sb.getMinimum());
                        ViewerCanvas.this.repaint();
                        break;
                    }
                    case 0x1000008: {
                        if (!ViewerCanvas.this.rViewer.canGotoLastPage()) break;
                        ViewerCanvas.this.rViewer.gotoLastPage();
                    }
                }
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private TraverseListener tListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            e.doit = true;
        }
    };
    private SelectionAdapter sListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ViewerCanvas.this.repaint();
            ViewerCanvas.this.redraw();
        }
    };
    private ControlListener cListener = new ControlListener(){

        public void controlResized(ControlEvent e) {
            if (ViewerCanvas.this.zoomMode != 0 && ViewerCanvas.this.zoomMode != 1) {
                float zm = ViewerCanvas.this.computeZoom();
                if (!ViewerCanvas.this.hasReport()) {
                    return;
                }
                if ((double)Math.abs(zm - ViewerCanvas.this.zoom) > 1.0E-5) {
                    ViewerCanvas.this.setZoomInternal(zm);
                    ViewerCanvas.this.rViewer.fireViewerModelChanged(false);
                }
            }
            ViewerCanvas.this.refresh();
        }

        public void controlMoved(ControlEvent e) {
        }
    };
    private int zoomMode = 0;
    private float zoom = 1.0f;
    private static final float[] zoomLevels = new float[]{0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 1.75f, 2.0f};
    private IReportViewerListener listener = new IReportViewerListener(){

        @Override
        public void viewerStateChanged(ReportViewerEvent evt) {
            if (!evt.isCurrentPage() && !ViewerCanvas.this.isDisposed()) {
                ViewerCanvas.this.refresh();
            }
        }
    };
    private JasperReportsContext jContext;
    boolean updatingScrollbars;

    public int getZoomMode() {
        return this.zoomMode;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoomMode(int zoomMode) {
        if (!this.hasReport()) {
            return;
        }
        if (zoomMode != this.getZoomMode()) {
            this.zoomMode = zoomMode;
            this.setZoomInternal(this.computeZoom());
            this.rViewer.fireViewerModelChanged(false);
        }
    }

    private float getMinZoom() {
        return zoomLevels[0];
    }

    private float getMaxZoom() {
        return zoomLevels[zoomLevels.length - 1];
    }

    public float getNextZoom() {
        int i = 0;
        while (i < zoomLevels.length) {
            if (this.zoom < zoomLevels[i]) {
                return zoomLevels[i];
            }
            ++i;
        }
        return this.getMaxZoom();
    }

    public float getPreviousZoom() {
        int i = zoomLevels.length - 1;
        while (i >= 0) {
            if (this.zoom > zoomLevels[i]) {
                return zoomLevels[i];
            }
            --i;
        }
        return this.getMinZoom();
    }

    public boolean canZoomIn() {
        return this.hasReport() && this.zoom < this.getMaxZoom();
    }

    public boolean canZoomOut() {
        return this.hasReport() && this.zoom > this.getMinZoom();
    }

    public void setZoomInternal(float zoom) {
        this.zoom = zoom;
    }

    public float[] getZoomLevels() {
        return zoomLevels;
    }

    public void zoomIn() {
        if (this.canZoomIn()) {
            this.setZoom(this.getNextZoom());
        }
    }

    public void zoomOut() {
        if (this.canZoomOut()) {
            this.setZoom(this.getPreviousZoom());
        }
    }

    public void setZoom(float zm) {
        if (!this.hasReport()) {
            return;
        }
        this.zoomMode = 0;
        if ((double)Math.abs(zm - this.zoom) > 1.0E-5) {
            this.setZoomInternal(zm);
            this.rViewer.fireViewerModelChanged(false);
        }
    }

    public boolean hasReport() {
        return this.rViewer.hasReport();
    }

    public float computeZoom() {
        JasperPrint doc = this.rViewer.getReport();
        if (doc == null) {
            return 1.0f;
        }
        int pageIndex = this.rViewer.getPageIndex();
        PrintPageFormat ppFormat = doc.getPageFormat(pageIndex);
        int pw = ppFormat.getPageWidth();
        int ph = ppFormat.getPageHeight();
        Point fitSize = this.getFitSize();
        switch (this.zoomMode) {
            case 1: {
                return 1.0f;
            }
            case 2: {
                double ratio = this.ratio(fitSize.x, pw);
                return this.ratio(this.getFitSize((int)((int)((double)pw * ratio)), (int)((int)((double)ph * ratio))).x, pw);
            }
            case 3: {
                double ratio = this.ratio(fitSize.y, ph);
                return this.ratio(this.getFitSize((int)((int)((double)pw * ratio)), (int)((int)((double)ph * ratio))).y, ph);
            }
            case 4: {
                return Math.min(this.ratio(fitSize.x, pw), this.ratio(fitSize.y, ph));
            }
        }
        return this.zoom;
    }

    private float ratio(int a, int b) {
        return (float)(a * 100 / b) / 100.0f;
    }

    public ViewerCanvas(Composite parent, int style, JasperReportsContext jContext) {
        super(parent, style | 0x100 | 0x200);
        this.jContext = jContext;
        this.addPaintListener(this.pListener);
        this.addMouseMoveListener(this.mMoveListener);
        this.addMouseListener(this.mListener);
        this.addKeyListener(this.keyListener);
        this.addTraverseListener(this.tListener);
        this.addControlListener(this.cListener);
        this.setupBar(this.getHorizontalBar());
        this.setupBar(this.getVerticalBar());
    }

    private void setupBar(ScrollBar sb) {
        sb.setIncrement(20);
        sb.addSelectionListener((SelectionListener)this.sListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        org.eclipse.swt.graphics.Rectangle b = this.getContentBounds();
        org.eclipse.swt.graphics.Rectangle trim = this.computeTrim(0, 0, ViewerCanvas.calcSize(wHint, b.width), ViewerCanvas.calcSize(hHint, b.height));
        return new Point(trim.width, trim.height);
    }

    private static int calcSize(int hint, int size) {
        if (hint != -1) {
            return hint;
        }
        return size > 0 ? size : 74;
    }

    private Image renderPage() throws Throwable {
        JasperPrint jr = this.rViewer.getReport();
        int pageIndex = this.rViewer.getPageIndex();
        PrintPageFormat pageFormat = jr.getPageFormat(pageIndex);
        BufferedImage img = null;
        float z = this.computeZoom();
        img = pageFormat != null ? new BufferedImage((int)((float)pageFormat.getPageWidth().intValue() * z) + 1, (int)((float)pageFormat.getPageHeight().intValue() * z) + 1, 1) : new BufferedImage((int)((float)jr.getPageWidth() * z) + 1, (int)((float)jr.getPageHeight() * z) + 1, 1);
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        if (pageIndex >= 0 && pageIndex <= this.rViewer.getPageIndex()) {
            try {
                JRGraphics2DExporter exporter = new JRGraphics2DExporter(this.jContext);
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jr));
                SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
                output.setGraphics2D(g2d);
                exporter.setExporterOutput((ExporterOutput)output);
                SimpleGraphics2DReportConfiguration grxConfiguration = new SimpleGraphics2DReportConfiguration();
                grxConfiguration.setPageIndex(Integer.valueOf(pageIndex));
                grxConfiguration.setZoomRatio(Float.valueOf(z));
                exporter.setConfiguration((ReportExportConfiguration)grxConfiguration);
                exporter.exportReport();
                g2d.setColor(Color.black);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawRect(0, 0, (int)((float)img.getWidth() / z), (int)((float)img.getHeight() / z));
            }
            finally {
                g2d.dispose();
            }
        }
        return UIUtils.awt2Swt(img);
    }

    public void setReportViewer(IReportViewer viewer) {
        if (this.rViewer != null) {
            this.rViewer.removeReportViewerListener(this.listener);
        }
        this.rViewer = viewer;
        if (this.rViewer != null) {
            this.rViewer.addReportViewerListener(this.listener);
        }
        this.refresh();
    }

    private void repaint() {
        if (this.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)this);
        try {
            this.paint(gc);
        }
        finally {
            gc.dispose();
        }
    }

    private void paint(GC gc) {
        org.eclipse.swt.graphics.Rectangle ca = this.getClientArea();
        ScrollBar hBar = this.getHorizontalBar();
        ScrollBar vBar = this.getVerticalBar();
        if (this.reportImage != null) {
            org.eclipse.swt.graphics.Rectangle b = this.reportImage.getBounds();
            gc.fillRectangle(0, 0, ca.width, ca.height);
            int x = b.width <= ca.width ? (ca.width - b.width) / 2 : -this.getHorizontalBar().getSelection() + 5;
            int y = b.height <= ca.height ? (ca.height - b.height) / 2 : -this.getVerticalBar().getSelection() + 5;
            gc.drawImage(this.reportImage, x, y);
        } else if (this.errorMessage != null) {
            org.eclipse.swt.graphics.Rectangle b = this.getContentBounds();
            int x = b.width > ca.width ? -hBar.getSelection() : 0;
            int y = b.height > ca.height ? -vBar.getSelection() : 0;
            gc.fillRectangle(ca);
            gc.setForeground(this.getDisplay().getSystemColor(3));
            gc.drawText(this.errorMessage, x + 5, y + 5);
        }
    }

    protected void refresh() {
        block10: {
            if (this.rViewer != null && this.hasReport()) {
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                try {
                    try {
                        List pages;
                        Object contextCL = this.jContext.getValue("CURRENT_CLASS_LOADER");
                        if (contextCL instanceof ClassLoader) {
                            Thread.currentThread().setContextClassLoader((ClassLoader)contextCL);
                        }
                        if ((pages = this.rViewer.getReport().getPages()).isEmpty()) {
                            this.refresh(null, "Document is Empty", null);
                        } else {
                            this.refresh(this.renderPage(), null, (JRPrintPage)pages.get(this.rViewer.getPageIndex()));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.refresh(null, e.getMessage(), null);
                        Thread.currentThread().setContextClassLoader(oldLoader);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    throw throwable;
                }
                Thread.currentThread().setContextClassLoader(oldLoader);
            } else {
                this.refresh(null, null, null);
            }
        }
        this.setFocus();
    }

    private void refresh(Image reportImage, String errorMessage, JRPrintPage page) {
        if (this.reportImage != null) {
            this.reportImage.dispose();
        }
        if (this.isDisposed()) {
            return;
        }
        this.reportImage = reportImage;
        this.errorMessage = errorMessage;
        this.page = page;
        this.setCursor(null);
        this.setToolTipText(null);
        this.currentLink = null;
        this.initHypelinks();
        ScrollBar hBar = this.getHorizontalBar();
        ScrollBar vBar = this.getVerticalBar();
        hBar.setSelection(0);
        vBar.setSelection(0);
        if (!this.updatingScrollbars) {
            try {
                this.updatingScrollbars = true;
                org.eclipse.swt.graphics.Rectangle b = this.getContentBounds();
                boolean hVisible = this.hasHScroll(b.width, false);
                boolean vVisible = this.hasVScroll(b.height, hVisible);
                if (!hVisible && vVisible) {
                    hVisible = this.hasHScroll(b.width, vVisible);
                }
                Point size = this.getSize();
                org.eclipse.swt.graphics.Rectangle clientArea = this.getClientArea();
                this.setupScrollBar(hBar, hVisible, clientArea.width, b.width, size.x);
                this.setupScrollBar(vBar, vVisible, clientArea.height, b.height, size.y);
            }
            finally {
                this.updatingScrollbars = false;
            }
        }
        this.redraw();
    }

    private void setupScrollBar(ScrollBar sb, boolean visible, int ca, int b, int size) {
        if (sb == null) {
            return;
        }
        sb.setVisible(visible);
        if (!visible) {
            sb.setSelection(0);
        } else {
            sb.setPageIncrement(ca - sb.getIncrement());
            int max = b + size - ca;
            sb.setMaximum(max);
            sb.setThumb(size > max ? max : size);
        }
    }

    private boolean hasHScroll(int w, boolean visible) {
        if (this.getHorizontalBar() == null) {
            return false;
        }
        org.eclipse.swt.graphics.Rectangle b = this.getBounds();
        b.width -= 2 * this.getBorderWidth();
        ScrollBar vBar = this.getVerticalBar();
        if (visible && vBar != null) {
            b.width -= vBar.getSize().x;
        }
        return w > b.width;
    }

    private boolean hasVScroll(int h, boolean visible) {
        if (this.getVerticalBar() == null) {
            return false;
        }
        org.eclipse.swt.graphics.Rectangle b = this.getBounds();
        b.height -= 2 * this.getBorderWidth();
        ScrollBar hBar = this.getHorizontalBar();
        if (visible && hBar != null) {
            b.height -= hBar.getSize().y;
        }
        return h > b.height;
    }

    public void dispose() {
        if (this.reportImage != null) {
            this.reportImage.dispose();
        }
        super.dispose();
    }

    public Point getFitSize() {
        org.eclipse.swt.graphics.Rectangle b = this.getBounds();
        int borderWidth = this.getBorderWidth();
        return new Point(b.width - 2 * borderWidth - 10, b.height - 2 * borderWidth - 10);
    }

    public Point getFitSize(int width, int height) {
        Point size = this.getFitSize();
        boolean vbar = false;
        boolean hbar = false;
        if (width > size.x) {
            size.y -= this.getHorizontalBar().getSize().y;
            hbar = true;
        }
        if (height > size.y) {
            size.x -= this.getVerticalBar().getSize().x;
            vbar = true;
        }
        if (vbar && !hbar && width > size.x) {
            size.y -= this.getHorizontalBar().getSize().y;
        }
        return size;
    }

    private void updateHyperlink(int x, int y) {
        JRPrintHyperlink link = this.getHyperlinkAt(x, y);
        if (link != null) {
            if (this.currentLink == null || this.currentLink != link) {
                this.currentLink = link;
                this.setCursor(CURSOR_HAND);
                this.setToolTipText(this.getLinkToolTip(link));
            }
        } else if (this.currentLink != null) {
            this.currentLink = null;
            this.setCursor(null);
            this.setToolTipText(null);
        }
    }

    private void handleHyperlinkClick() {
        switch (this.currentLink.getHyperlinkTypeValue()) {
            case REFERENCE: 
            case REMOTE_ANCHOR: 
            case REMOTE_PAGE: 
            case CUSTOM: {
                this.notifyHyperlinkListeners(this.currentLink);
                break;
            }
            case LOCAL_ANCHOR: {
                Map anchorIndexes = this.rViewer.getReport().getAnchorIndexes();
                JRPrintAnchorIndex indx = (JRPrintAnchorIndex)anchorIndexes.get(this.currentLink.getHyperlinkAnchor());
                if (indx == null) {
                    return;
                }
                if (indx.getPageIndex() != this.rViewer.getPageIndex()) {
                    this.rViewer.setPageIndex(indx.getPageIndex());
                }
                if (this.reportImage == null) break;
                JRPrintElement p = indx.getElement();
                this.setScrollBarSelection(this.getHorizontalBar(), (int)((float)p.getX() * this.zoom));
                this.setScrollBarSelection(this.getVerticalBar(), (int)((float)p.getY() * this.zoom));
                this.repaint();
                break;
            }
            case LOCAL_PAGE: {
                this.rViewer.setPageIndex(this.currentLink.getHyperlinkPage() - 1);
            }
        }
    }

    private void setScrollBarSelection(ScrollBar sb, int selection) {
        sb.setSelection(Math.max(sb.getMinimum(), Math.min(selection, sb.getMaximum())));
        this.redraw();
    }

    private org.eclipse.swt.graphics.Rectangle getContentBounds() {
        if (this.reportImage != null) {
            org.eclipse.swt.graphics.Rectangle bounds = this.reportImage.getBounds();
            bounds.width += 10;
            bounds.height += 10;
            return bounds;
        }
        if (this.errorMessage != null) {
            GC gc = new GC((Drawable)this);
            Point extent = gc.textExtent(this.errorMessage);
            gc.dispose();
            return new org.eclipse.swt.graphics.Rectangle(0, 0, extent.x + 10, extent.y + 10);
        }
        return new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
    }

    private JRPrintHyperlink getHyperlinkAt(int x, int y) {
        org.eclipse.swt.graphics.Rectangle b = this.reportImage.getBounds();
        org.eclipse.swt.graphics.Rectangle ca = this.getClientArea();
        int oX = b.width <= ca.width ? (ca.width - b.width) / 2 : -this.getHorizontalBar().getSelection() + 5;
        int oY = b.height <= ca.height ? (ca.height - b.height) / 2 : -this.getVerticalBar().getSelection() + 5;
        Point point = new Point((int)((float)(x - oX - ca.x) / this.zoom), (int)((float)(y - oY - ca.y) / this.zoom));
        ListIterator<IHyperlinkContainer> it = this.links.listIterator(this.links.size());
        while (it.hasPrevious()) {
            JRPrintHyperlink hyperlink = it.previous().getHyperlink(point);
            if (hyperlink == null) continue;
            return hyperlink;
        }
        return null;
    }

    private void initHypelinks() {
        this.links.clear();
        if (this.page == null) {
            return;
        }
        List elements = this.page.getElements();
        if (elements == null) {
            return;
        }
        for (JRPrintElement element : elements) {
            if (element instanceof JRPrintImage) {
                Renderable r = ((JRPrintImage)element).getRenderer();
                if (!(r instanceof AreaHyperlinksRenderable)) continue;
                try {
                    List hyperlinks = ((AreaHyperlinksRenderable)r).getImageAreaHyperlinks((Rectangle2D)new Rectangle(0, 0, element.getWidth(), element.getHeight()));
                    if (hyperlinks == null) continue;
                    this.links.add(new ImageAreaHyperlink(element.getX(), element.getY(), hyperlinks));
                    continue;
                }
                catch (JRException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(element instanceof JRPrintHyperlink) || ((JRPrintHyperlink)element).getHyperlinkTypeValue().equals((Object)HyperlinkTypeEnum.NONE)) continue;
            this.links.add(new PrintHyperlink(0, 0, element));
        }
    }

    private String getLinkToolTip(JRPrintHyperlink link) {
        String tTip = link.getHyperlinkTooltip();
        if (tTip == null) {
            HyperlinkTypeEnum hType = link.getHyperlinkTypeValue();
            if (hType.equals((Object)HyperlinkTypeEnum.REFERENCE)) {
                tTip = link.getHyperlinkReference();
            } else if (hType.equals((Object)HyperlinkTypeEnum.LOCAL_ANCHOR)) {
                if (link.getHyperlinkAnchor() != null) {
                    tTip = "#" + link.getHyperlinkAnchor();
                }
            } else if (hType.equals((Object)HyperlinkTypeEnum.LOCAL_PAGE)) {
                if (link.getHyperlinkPage() != null) {
                    tTip = "#page " + link.getHyperlinkPage();
                }
            } else if (hType.equals((Object)HyperlinkTypeEnum.REMOTE_ANCHOR)) {
                if (link.getHyperlinkReference() != null) {
                    tTip = link.getHyperlinkReference();
                }
                if (this.currentLink.getHyperlinkAnchor() != null) {
                    tTip = "#" + this.currentLink.getHyperlinkAnchor();
                }
            } else if (hType.equals((Object)HyperlinkTypeEnum.REMOTE_PAGE)) {
                if (link.getHyperlinkReference() != null) {
                    tTip = link.getHyperlinkReference();
                }
                if (link.getHyperlinkPage() != null) {
                    tTip = "#page " + link.getHyperlinkPage();
                }
            }
        }
        return tTip;
    }

    private void notifyHyperlinkListeners(JRPrintHyperlink link) {
        JRHyperlinkListener[] jRHyperlinkListenerArray = this.rViewer.getHyperlinkListeners();
        int n = jRHyperlinkListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRHyperlinkListener l = jRHyperlinkListenerArray[n2];
            try {
                l.gotoHyperlink(link);
            }
            catch (JRException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
    }

    public Image getActualImage() {
        return this.reportImage;
    }

    private static interface IHyperlinkContainer {
        public JRPrintHyperlink getHyperlink(Point var1);
    }

    private static class ImageAreaHyperlink
    implements IHyperlinkContainer {
        private int originX;
        private int originY;
        private List<JRPrintImageAreaHyperlink> imageAreaHyperlinks;

        public ImageAreaHyperlink(int originX, int originY, List<JRPrintImageAreaHyperlink> imageAreaHyperlinks) {
            this.originX = originX;
            this.originY = originY;
            this.imageAreaHyperlinks = imageAreaHyperlinks;
        }

        @Override
        public JRPrintHyperlink getHyperlink(Point point) {
            int x = point.x - this.originX;
            int y = point.y - this.originY;
            for (JRPrintImageAreaHyperlink areaHyperlink : this.imageAreaHyperlinks) {
                if (!areaHyperlink.getArea().containsPoint(x, y)) continue;
                return areaHyperlink.getHyperlink();
            }
            return null;
        }
    }

    private static class PrintHyperlink
    implements IHyperlinkContainer {
        private final int x;
        private final int y;
        private final JRPrintElement element;

        public PrintHyperlink(int originX, int originY, JRPrintElement element) {
            this.x = originX + element.getX();
            this.y = originY + element.getY();
            this.element = element;
        }

        @Override
        public JRPrintHyperlink getHyperlink(Point point) {
            if (point.x >= this.x && point.x < this.x + this.element.getWidth() && point.y >= this.y && point.y < this.y + this.element.getHeight()) {
                return (JRPrintHyperlink)this.element;
            }
            return null;
        }
    }
}

