/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.wizard.project;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.wizard.project.JRProjectPage;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class JRProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    boolean proceed = true;
    protected JRProjectPage step1;

    public JRProjectWizard() {
        this.setWindowTitle(Messages.JRProjectWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.step1 = new JRProjectPage();
        this.addPage((IWizardPage)this.step1);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    JRProjectWizard.this.doFinish(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError(e.getCause());
        }
        catch (InterruptedException e) {
            UIUtils.showError(e);
        }
        return true;
    }

    protected void doFinish(IProgressMonitor monitor) {
        this.proceed = true;
        String prjName = this.step1.getName();
        if (ProjectUtil.hasExistingContent(prjName)) {
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    JRProjectWizard.this.proceed = MessageDialog.openQuestion((Shell)UIUtils.getShell(), (String)Messages.JRProjectWizard_OverwriteQuestionTitle, (String)Messages.JRProjectWizard_OverwriteQuestionMsg);
                }
            });
        }
        if (this.proceed) {
            ProjectUtil.deleteProjectFolder(prjName);
            IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(prjName);
            if (!prj.exists()) {
                IProjectDescription desc = prj.getWorkspace().newProjectDescription(prj.getName());
                try {
                    prj.create(desc, null);
                    if (!prj.isOpen()) {
                        prj.open(null);
                    }
                    this.createProject(monitor, prj);
                }
                catch (CoreException e) {
                    UIUtils.showError(e);
                }
                catch (FileNotFoundException e) {
                    UIUtils.showError(e);
                }
            }
        }
    }

    protected void createProject(IProgressMonitor monitor, IProject prj) throws CoreException, FileNotFoundException {
        ProjectUtil.createJRProject(monitor, prj);
    }
}

