/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.wizard.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.classpath.container.JRClasspathContainer;
import net.sf.jasperreports.eclipse.messages.Messages;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.ui.PreferenceConstants;

public class ProjectUtil {
    private static final String REQUIRED_JAVA = "JavaSE-11";

    public static void createJRProject(IProgressMonitor monitor, IProject prj) throws CoreException, JavaModelException {
        ProjectUtil.addNature(prj, "org.eclipse.jdt.core.javanature", monitor);
        ArrayList<IClasspathEntry> centries = new ArrayList<IClasspathEntry>();
        IJavaProject javaProject = JavaCore.create((IProject)prj);
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        IPath execPath = null;
        int i = 0;
        while (i < environments.length) {
            IExecutionEnvironment currentEnvoirement = environments[i];
            String id = currentEnvoirement.getId();
            if (id != null && id.equals(REQUIRED_JAVA)) {
                execPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)currentEnvoirement);
                break;
            }
            ++i;
        }
        if (execPath != null) {
            centries.add(JavaCore.newContainerEntry(execPath));
        } else {
            IClasspathEntry[] jreClasspath = PreferenceConstants.getDefaultJRELibrary();
            centries.addAll(Arrays.asList(jreClasspath));
            JasperReportsPlugin.getDefault().logWarning(MessageFormat.format(Messages.ProjectUtil_executionEnvironmentError, REQUIRED_JAVA));
        }
        IFolder folder = prj.getFolder(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
        folder.create(1025, true, monitor);
        folder.setDerived(true, monitor);
        prj.refreshLocal(2, monitor);
        ProjectUtil.addNature(prj, "net.sf.jasperreports.nature", monitor);
        ProjectUtil.createJRClasspathContainer(monitor, centries, javaProject);
    }

    public static boolean hasJRNature(IProgressMonitor monitor, IProject project) {
        try {
            if (!project.isOpen()) {
                project.open(monitor);
            }
            return project.hasNature("org.eclipse.jdt.core.javanature") && project.hasNature("net.sf.jasperreports.nature");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void createJRClasspathContainer(IProgressMonitor monitor, IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] entries;
        ArrayList<IClasspathEntry> centries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = entries = javaProject.readRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry en = iClasspathEntryArray[n2];
            if (en.getPath().equals((Object)JRClasspathContainer.ID)) {
                return;
            }
            ++n2;
        }
        centries.addAll(Arrays.asList(entries));
        ProjectUtil.createJRClasspathContainer(null, centries, javaProject);
    }

    public static void createJRClasspathContainer(IProgressMonitor monitor, List<IClasspathEntry> centries, IJavaProject javaProject) throws JavaModelException {
        JRClasspathContainer classpathContainer = new JRClasspathContainer(null, javaProject);
        JavaCore.setClasspathContainer((IPath)JRClasspathContainer.ID, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, (IProgressMonitor)monitor);
        centries.add(JavaCore.newContainerEntry((IPath)JRClasspathContainer.ID, (boolean)true));
        javaProject.setRawClasspath(centries.toArray(new IClasspathEntry[centries.size()]), monitor);
        JasperReportsPlugin.getClasspathContainerManager().createJRClasspathContainer(monitor, centries, javaProject);
    }

    public static void addNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        if (!project.isOpen()) {
            project.open(monitor);
        }
        if (!project.hasNature(nature)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = nature;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    public static boolean isOpen(IProject prj) {
        return prj.exists() && prj.isOpen() && prj.isAccessible();
    }

    public static void addFileToClasspath(IProgressMonitor monitor, IFile file) throws CoreException {
        if (file.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
            IClasspathEntry[] entries;
            IJavaProject jprj = JavaCore.create((IProject)file.getProject());
            ArrayList<IClasspathEntry> centries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = entries = jprj.readRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry en = iClasspathEntryArray[n2];
                if (en.getPath().equals((Object)file.getFullPath())) {
                    return;
                }
                ++n2;
            }
            centries.add(JavaCore.newLibraryEntry((IPath)file.getFullPath(), null, null));
            centries.addAll(Arrays.asList(entries));
            jprj.setRawClasspath(centries.toArray(new IClasspathEntry[centries.size()]), monitor);
        }
    }

    public static boolean hasExistingContent(String prjName) {
        try {
            URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
            URI prjLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(prjName).toString(), null);
            IFileStore file = EFS.getStore((URI)prjLocation);
            return file.fetchInfo().exists();
        }
        catch (URISyntaxException e) {
            JasperReportsPlugin.getDefault().logError(e);
        }
        catch (CoreException e) {
            JasperReportsPlugin.getDefault().logError(e);
        }
        return false;
    }

    public static void deleteProjectFolder(String prjName) {
        try {
            URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
            URI prjLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(prjName).toString(), null);
            File prjDir = new File(prjLocation);
            if (prjDir.exists()) {
                FileUtils.deleteDirectory((File)prjDir);
            }
        }
        catch (URISyntaxException e) {
            JasperReportsPlugin.getDefault().logError(e);
        }
        catch (IOException e) {
            JasperReportsPlugin.getDefault().logError(e);
        }
    }
}

