/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.swt;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.swt.ColorManager;

public class ResourceCache
extends ColorManager {
    protected Map<String, Font> fFontTable = new HashMap<String, Font>(10);
    protected Map<Object, Image> fImageTable = new HashMap<Object, Image>(10);

    @Override
    public void dispose() {
        super.dispose();
        Iterator<Font> f = this.fFontTable.values().iterator();
        while (f.hasNext()) {
            f.next().dispose();
        }
        this.fFontTable.clear();
        Iterator<Image> i = this.fImageTable.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        this.fImageTable.clear();
    }

    public Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = this.fImageTable.get(descriptor);
        if (image != null && image.isDisposed()) {
            this.fImageTable.remove(descriptor);
            image = null;
        }
        if (image == null) {
            image = descriptor.createImage();
            this.fImageTable.put(descriptor, image);
        }
        return image;
    }

    public Font getFont(String fontName, int fontSize, int fontStyle) {
        String key = String.valueOf(fontName) + Integer.toString(fontSize) + Integer.toString(fontStyle);
        Font font = this.fFontTable.get(key);
        if (font == null) {
            font = new Font((Device)Display.getCurrent(), fontName, fontSize, fontStyle);
            this.fFontTable.put(key, font);
        }
        return font;
    }

    public Font getFont(FontData fd) {
        return this.getFont(fd.getName(), fd.getHeight(), fd.getStyle());
    }

    public Image getImage(ImageData data) {
        if (data == null) {
            return null;
        }
        Image img = this.fImageTable.get(data);
        if (img != null && img.isDisposed()) {
            this.fImageTable.remove(data);
            img = null;
        }
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), data);
            this.fImageTable.put(data, img);
        }
        return img;
    }

    public Image getImage(InputStream stream) {
        Image img = this.fImageTable.get(stream);
        if (img != null && img.isDisposed()) {
            this.fImageTable.remove(stream);
            img = null;
        }
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), stream);
            this.fImageTable.put(stream, img);
        }
        return img;
    }

    public Image getImage(String key) {
        Image img = this.fImageTable.get(key);
        if (img != null && img.isDisposed()) {
            img = null;
            this.fImageTable.remove(key);
        }
        return img;
    }

    public boolean storeImage(String key, Image image) {
        if (this.fImageTable.containsKey(key)) {
            return false;
        }
        this.fImageTable.put(key, image);
        return true;
    }
}

