/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.rcp.intro;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.rcp.OpenDocumentEventProcessor;
import com.jaspersoft.studio.rcp.intro.ApplicationWorkbenchAdvisor;
import com.jaspersoft.studio.rcp.workspace.PickWorkspaceDialog;
import com.jaspersoft.studio.statistics.UsageManager;
import com.jaspersoft.studio.statistics.heartbeat.CommunityLoginDialog;
import java.net.URL;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";

    public Object start(IApplicationContext context) throws Exception {
        OpenDocumentEventProcessor openDocProcessor = new OpenDocumentEventProcessor();
        Display display = PlatformUI.createDisplay();
        display.addListener(46, (Listener)openDocProcessor);
        try {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc != null && !instanceLoc.isSet()) {
                instanceLoc.set(new URL("file", null, PickWorkspaceDialog.getLastSetWorkspaceDirectory()), false);
            }
            if (!UsageManager.isCommunityLoginValid()) {
                CommunityLoginDialog d = new CommunityLoginDialog(UIUtils.getShell());
                int result = d.open();
                if (result == 1) {
                    try {
                        PlatformUI.getWorkbench().close();
                    }
                    catch (Exception exception) {}
                    System.exit(0);
                    Integer n = IApplication.EXIT_OK;
                    return n;
                }
                JaspersoftStudioPlugin.getInstance().getUsageManager().confirmSuccessfulCommunityLogin(d.getUserEmail());
            } else {
                JaspersoftStudioPlugin.getInstance().getUsageManager().audit("Startup", "Startup");
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor(openDocProcessor));
            if (returnCode != 1) {
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : EXIT_RESTART;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

