/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.services;

import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;

public class CustomTerminalConverters
extends DefaultTerminalConverters {
    private static final int RADIX_8 = 8;
    private static final int RADIX_16 = 16;

    @ValueConverter(rule="INT")
    public IValueConverter<Integer> INT() {
        return new IValueConverter<Integer>(){

            public Integer toValue(String string, INode node) throws ValueConverterException {
                if (string.startsWith("0x") || string.startsWith("0X")) {
                    String stripped = string.substring(2, string.length());
                    return Integer.parseInt(stripped, 16);
                }
                if (string.startsWith("0")) {
                    return Integer.parseInt(string, 8);
                }
                return Integer.parseInt(string);
            }

            public String toString(Integer value) throws ValueConverterException {
                return value.toString();
            }
        };
    }

    @ValueConverter(rule="LONG")
    public IValueConverter<Long> LONG() {
        return new IValueConverter<Long>(){

            public Long toValue(String string, INode node) throws ValueConverterException {
                if (string.endsWith("l") || string.endsWith("L")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.startsWith("0x") || string.startsWith("0X")) {
                    String stripped = string.substring(2, string.length());
                    return Long.parseLong(stripped, 16);
                }
                if (string.startsWith("0")) {
                    String stripped = string.substring(0, string.length());
                    return Long.parseLong(stripped, 8);
                }
                return Long.parseLong(string);
            }

            public String toString(Long value) throws ValueConverterException {
                return value.toString();
            }
        };
    }
}

