/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.translation.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public abstract class AbstractResourceDefinition {
    private static HashMap<String, Hashtable<Object, Object>> stringsMap = new HashMap();

    public String[] getKeys() {
        Hashtable<Object, Object> map = this.getMap();
        Set<Object> keys = map.keySet();
        String[] result = new String[keys.size()];
        int i = 0;
        for (Object key : keys) {
            result[i] = key.toString();
            ++i;
        }
        return result;
    }

    public String[] getValues() {
        Hashtable<Object, Object> map = this.getMap();
        String[] result = new String[map.values().size()];
        String[] keys = this.getKeys();
        int i = 0;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            result[i] = this.getValue(key);
            ++i;
            ++n2;
        }
        return result;
    }

    protected Hashtable<Object, Object> getMap() {
        String uniqueId = this.getUniqueId();
        Properties result = stringsMap.get(uniqueId);
        if (result == null) {
            result = new Properties();
            try {
                InputStream is = this.getFileInput();
                if (is != null) {
                    result.load(is);
                    stringsMap.put(uniqueId, result);
                } else {
                    System.out.println("Resource " + uniqueId + " not found");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Hashtable<Object, Object> getLocalizedProerties(Locale loc) {
        InputStream is = this.getLocalizedInput(loc);
        Properties result = new Properties();
        if (is == null) {
            return result;
        }
        try {
            result.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getValue(String key) {
        Hashtable<Object, Object> map = this.getMap();
        Object value = map.get(key);
        return value != null ? value.toString() : null;
    }

    public String getFileNameWithoutExtension() {
        String fileName = this.getFileName();
        if (fileName.endsWith(".properties")) {
            return fileName.substring(0, fileName.length() - 11);
        }
        return fileName;
    }

    public String getUniqueId() {
        return String.valueOf(this.getPluginName()) + this.getPackageName() + this.getFileName();
    }

    protected abstract InputStream getFileInput();

    protected abstract InputStream getLocalizedInput(Locale var1);

    public abstract String getDescription();

    public abstract String getPackageName();

    public abstract String getFileName();

    public abstract String getLocale();

    public abstract String getPluginName();

    public static boolean safeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o2 != null && o1.equals(o2);
    }

    public boolean equals(Object obj) {
        AbstractResourceDefinition resource = (AbstractResourceDefinition)obj;
        return AbstractResourceDefinition.safeEquals(this.getPackageName(), resource.getPackageName()) && AbstractResourceDefinition.safeEquals(this.getPluginName(), resource.getPluginName());
    }
}

