/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.translation.wizard;

import com.jaspersoft.translation.resources.AbstractResourceDefinition;
import com.jaspersoft.translation.resources.IResourcesInput;
import com.jaspersoft.translation.wizard.HelpWizardPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class GetinputNewWizardPage
extends HelpWizardPage {
    private TreeViewer resourceList;
    private List<AbstractResourceDefinition> selectedElement = new ArrayList<AbstractResourceDefinition>();
    private Label packageLbl;
    private Label pluginLbl;
    private Label fileNameLbl;
    private Label descriptionLbl;
    private Composite parentControl;
    private static List<IResourcesInput> loadedElementsList = null;
    private static final String HELP_ID = "com.jaspersoft.studio.babel.editor.newResourceHelp";

    protected GetinputNewWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.resource_wiz_title);
        this.setDescription(Messages.resource_wiz_description);
    }

    private void getResourceInput() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio.babel.editor.resourceInput");
        loadedElementsList = new ArrayList<IResourcesInput>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object input = element.createExecutableExtension("class");
                if (input instanceof IResourcesInput) {
                    IResourcesInput parent = (IResourcesInput)input;
                    loadedElementsList.add(parent);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        Collections.sort(loadedElementsList);
    }

    public void createControl(Composite parent) {
        if (loadedElementsList == null) {
            this.getResourceInput();
        }
        this.parentControl = parent;
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1040));
        container.setLayout((Layout)new GridLayout(2, false));
        this.resourceList = new TreeViewer(container);
        this.resourceList.setContentProvider((IContentProvider)new ViewContentProvider());
        this.resourceList.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.resourceList.setInput(loadedElementsList);
        GridData treeData = new GridData(1808);
        treeData.widthHint = 350;
        this.resourceList.getControl().setLayoutData((Object)treeData);
        Group infoGroup = new Group(container, 0);
        infoGroup.setText(Messages.resource_wiz_information_title);
        infoGroup.setLayout((Layout)new GridLayout(2, false));
        GridData infoData = new GridData(1808);
        infoData.widthHint = 300;
        infoGroup.setLayoutData((Object)infoData);
        this.pluginLbl = this.createInfoElement((Composite)infoGroup, Messages.resource_wiz_information_plugin, "");
        this.packageLbl = this.createInfoElement((Composite)infoGroup, Messages.resource_wiz_information_package, "");
        this.fileNameLbl = this.createInfoElement((Composite)infoGroup, Messages.resource_wiz_information_name, "");
        this.descriptionLbl = this.createInfoElement((Composite)infoGroup, Messages.resource_wiz_information_description, "");
        Tree tree = (Tree)this.resourceList.getControl();
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetinputNewWizardPage.this.updateDescription((TreeItem)e.item);
            }
        });
        this.setControl((Control)container);
    }

    private TreeItem[] getSelectedElements() {
        Tree tree = (Tree)this.resourceList.getControl();
        return tree.getSelection();
    }

    private void updateDescription(TreeItem item) {
        if (item != null) {
            if (item.getData() instanceof AbstractResourceDefinition) {
                AbstractResourceDefinition resource = (AbstractResourceDefinition)item.getData();
                this.pluginLbl.setText(resource.getPluginName());
                this.fileNameLbl.setText(resource.getFileName());
                this.descriptionLbl.setText(resource.getDescription());
                if (resource.getPackageName() != null) {
                    this.packageLbl.setText(resource.getPackageName());
                } else {
                    this.packageLbl.setText(Messages.resource_wiz_information_noPackage);
                }
                this.parentControl.layout(true, true);
                if (item.getParent() != null) {
                    this.getHelpData(item.getParentItem().getData());
                }
            } else {
                this.getHelpData(item.getData());
            }
        }
        this.setPageComplete(this.canFlipToNextPage());
    }

    private void getHelpData(Object item) {
        if (this.getSelectedElements().length == 0) {
            this.setContextName(HELP_ID);
        } else if (item instanceof IResourcesInput) {
            String heldId = ((IResourcesInput)item).getContextId();
            if (heldId != null) {
                this.setContextName(heldId);
            } else {
                this.setContextName(HELP_ID);
            }
        }
    }

    private Label createInfoElement(Composite parent, String label, String value) {
        Label desc = new Label(parent, 0);
        desc.setText(label);
        GridData titleData = new GridData();
        titleData.verticalAlignment = 128;
        desc.setLayoutData((Object)titleData);
        Label valLabel = new Label(parent, 64);
        valLabel.setText(value);
        valLabel.setLayoutData((Object)new GridData(768));
        return valLabel;
    }

    private void buildSelectedItemSet(HashMap<String, AbstractResourceDefinition> store, TreeItem actualElement) {
        AbstractResourceDefinition resource;
        String resourceId;
        if (actualElement.getData() instanceof IResourcesInput) {
            IResourcesInput resourcesContainer = (IResourcesInput)actualElement.getData();
            for (AbstractResourceDefinition resource2 : resourcesContainer.getResourcesElements()) {
                String resourceId2 = resource2.getUniqueId();
                if (store.containsKey(resourceId2)) continue;
                store.put(resourceId2, resource2);
            }
        } else if (actualElement.getData() instanceof AbstractResourceDefinition && !store.containsKey(resourceId = (resource = (AbstractResourceDefinition)actualElement.getData()).getUniqueId())) {
            store.put(resourceId, resource);
        }
    }

    public IWizardPage getNextPage() {
        HashMap<String, AbstractResourceDefinition> selectedResources = new HashMap<String, AbstractResourceDefinition>();
        TreeItem[] treeItemArray = this.getSelectedElements();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.buildSelectedItemSet(selectedResources, item);
            ++n2;
        }
        this.selectedElement.clear();
        this.selectedElement = new ArrayList(selectedResources.values());
        return super.getNextPage();
    }

    public List<AbstractResourceDefinition> getSelectedResource() {
        return this.selectedElement;
    }

    public boolean canFlipToNextPage() {
        return this.getSelectedElements().length > 0;
    }

    @Override
    protected String getContextName() {
        return HELP_ID;
    }

    protected class ViewContentProvider
    implements ITreeContentProvider {
        protected ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Collection) {
                return ((Collection)parentElement).toArray();
            }
            return ((IResourcesInput)parentElement).getResourcesElements().toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractResourceDefinition) {
                return ((AbstractResourceDefinition)element).getPluginName();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IResourcesInput || element instanceof Collection;
        }
    }

    protected class ViewLabelProvider
    extends LabelProvider {
        protected ViewLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return element.toString();
            }
            if (element instanceof AbstractResourceDefinition) {
                AbstractResourceDefinition resource = (AbstractResourceDefinition)element;
                String packageName = resource.getPackageName() != null ? String.valueOf(resource.getPackageName()) + ":" : "";
                return String.valueOf(packageName) + resource.getFileName();
            }
            if (element instanceof IResourcesInput) {
                return ((IResourcesInput)element).getPluginName();
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

