/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.translation.wizard;

import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class HelpWizardPage
extends WizardPage {
    private String contextName = this.getContextName();

    protected HelpWizardPage(String pageName) {
        super(pageName);
    }

    protected HelpWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected abstract String getContextName();

    protected void setContextName(String contextName) {
        this.contextName = contextName;
    }

    private void removeOtherHelp(Control newControl) {
        Shell shell = newControl.getShell();
        ArrayList<Listener> controlToRemove = new ArrayList<Listener>();
        Listener[] listenerArray = shell.getListeners(28);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener lst = listenerArray[n2];
            controlToRemove.add(lst);
            ++n2;
        }
        for (Listener lst : controlToRemove) {
            shell.removeListener(28, lst);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Control newControl = this.getControl();
            this.removeOtherHelp(newControl);
            newControl.getShell().addListener(28, new Listener(){

                public void handleEvent(Event event) {
                    HelpWizardPage.this.performHelp();
                }
            });
            this.setHelpData();
        }
    }

    public void setHelpData() {
        if (this.contextName != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.contextName);
        }
    }

    public void performHelp() {
        if (this.contextName != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.contextName);
        }
    }
}

