/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.translation.wizard;

import com.jaspersoft.translation.resources.AbstractResourceDefinition;
import com.jaspersoft.translation.resources.TranslationProjectNature;
import com.jaspersoft.translation.wizard.GetinputNewWizardPage;
import com.jaspersoft.translation.wizard.TranslationBundleNewWizardPage;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.babel.editor.wizards.internal.ResourceBundleNewWizardPage;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class TranslateBundleWizard
extends Wizard
implements INewWizard {
    private GetinputNewWizardPage page0;
    private TranslationBundleNewWizardPage page1;
    private ISelection selection;
    public static final String GENERATED_BY = "#Generated by Eclispe ResourceBundle Editor ";
    private boolean showGeneratorString = true;

    public TranslateBundleWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.editor_wiz_window_title);
    }

    public void addPages() {
        this.page0 = new GetinputNewWizardPage("Resource slection");
        this.addPage((IWizardPage)this.page0);
        this.page1 = new TranslationBundleNewWizardPage(this.selection);
        this.addPage((IWizardPage)this.page1);
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(folderPath);
    }

    public IFolder createNewFolder(String containerName, String folderName, IProgressMonitor monitor) {
        Path containerPath = new Path(containerName);
        IPath newFolderPath = containerPath.append(folderName);
        IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        CreateFolderOperation op = new CreateFolderOperation(newFolderHandle, null, false, null, "New Folder");
        try {
            op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        }
        catch (ExecutionException e) {
            this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (e.getCause() instanceof CoreException) {
                        ErrorDialog.openError((Shell)TranslateBundleWizard.this.getContainer().getShell(), (String)"Creation Problems", null, (IStatus)((CoreException)e.getCause()).getStatus());
                    } else {
                        MessageDialog.openError((Shell)TranslateBundleWizard.this.getContainer().getShell(), (String)"Creation problems", (String)NLS.bind((String)"Eclipse Internal error: {0}", (Object)e.getCause().getMessage()));
                    }
                }
            });
        }
        return newFolderHandle;
    }

    private IProject checkAndCreatePrject(String projectName, IProgressMonitor monitor) {
        IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!prj.exists()) {
            IProjectDescription desc = prj.getWorkspace().newProjectDescription(prj.getName());
            try {
                prj.create(desc, null);
                if (!prj.isOpen()) {
                    prj.open(null);
                }
                TranslationProjectNature.createJRProject(monitor, prj);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return prj;
    }

    public boolean performFinish() {
        final String containerName = this.page1.getContainerName();
        final String[] locales = this.page1.getLocaleStrings();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.worked(1);
                        monitor.setTaskName(Messages.editor_wiz_creating);
                        IProject prj = TranslateBundleWizard.this.checkAndCreatePrject(containerName, monitor);
                        for (AbstractResourceDefinition resource : TranslateBundleWizard.this.getSelectedResource()) {
                            String[] stringArray = locales;
                            int n = locales.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String locale = stringArray[n2];
                                String fileName = resource.getFileNameWithoutExtension();
                                fileName = locale.equals(ResourceBundleNewWizardPage.DEFAULT_LOCALE) ? String.valueOf(fileName) + ".properties" : String.valueOf(fileName) + "_" + locale + ".properties";
                                if (TranslateBundleWizard.this.page1.needToCreateFolder()) {
                                    String pluginName = resource.getPluginName();
                                    IFolder folder = TranslateBundleWizard.this.createNewFolder(containerName, pluginName, monitor);
                                    if (resource.getPackageName() != null) {
                                        folder = TranslateBundleWizard.this.createNewFolder(folder.getFullPath().toString(), resource.getPackageName(), monitor);
                                    }
                                    monitor.beginTask(String.valueOf(Messages.editor_wiz_creating) + fileName, 2);
                                    IResource containerResource = ResourcesPlugin.getWorkspace().getRoot().findMember(folder.getFullPath());
                                    if (!containerResource.exists() || !(containerResource instanceof IContainer)) {
                                        TranslateBundleWizard.this.throwCoreException("Container \"" + folder.getFullPath().toString() + "\" does not exist.");
                                    }
                                    TranslateBundleWizard.this.createFile(containerResource, fileName, resource, locale, monitor);
                                } else {
                                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                                    IResource containerResource = root.findMember((IPath)new Path(containerName));
                                    if (!containerResource.exists() || !(containerResource instanceof IContainer)) {
                                        TranslateBundleWizard.this.throwCoreException("Container \"" + containerName + "\" does not exist.");
                                    }
                                    TranslateBundleWizard.this.createFile(containerResource, fileName, resource, locale, monitor);
                                }
                                ++n2;
                            }
                        }
                        prj.refreshLocal(2, monitor);
                        monitor.worked(1);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    protected IFile createFile(IResource containerResource, String fileName, AbstractResourceDefinition sourceResource, String locale, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(Messages.editor_wiz_creating) + fileName, 2);
        IContainer container = (IContainer)containerResource;
        IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (!file.exists()) {
                file.create(stream, true, monitor);
            }
            Properties languageFile = this.fillFile(stream, sourceResource, locale);
            String packageName = sourceResource.getPackageName() != null ? String.valueOf(sourceResource.getPackageName()) + ":" : "";
            String comment = "source=" + packageName + sourceResource.getFileName();
            FileOutputStream outStream = new FileOutputStream(file.getLocation().toFile());
            languageFile.store(outStream, comment);
            stream.close();
            outStream.close();
            file.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private Properties fillFile(InputStream file, AbstractResourceDefinition sourceResource, String locale) {
        Properties languageFile = new Properties();
        try {
            languageFile.load(file);
            String[] keys = sourceResource.getKeys();
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                languageFile.put(key, sourceResource.getValue(key));
                ++n2;
            }
            Locale actualLocale = new Locale(locale.split("_")[0]);
            Hashtable<Object, Object> alreadyLocProperties = sourceResource.getLocalizedProerties(actualLocale);
            for (Object e : alreadyLocProperties.keySet()) {
                languageFile.put(e, alreadyLocProperties.get(e));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return languageFile;
    }

    public boolean canFinish() {
        return this.page1.isPageComplete();
    }

    private InputStream openContentStream() {
        String contents = "";
        if (this.showGeneratorString) {
            contents = GENERATED_BY;
        }
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.jaspersoft.studio.resourceBundleEditor.i18n.resourcebundle", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public List<AbstractResourceDefinition> getSelectedResource() {
        return this.page0.getSelectedResource();
    }

    public void init(IWorkbench workbench, IStructuredSelection structSelection) {
        this.selection = structSelection;
    }
}

