/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.translation.wizard;

import com.jaspersoft.translation.action.NatureTranslationTester;
import com.jaspersoft.translation.wizard.TranslateBundleWizard;
import org.eclipse.babel.editor.wizards.internal.ResourceBundleNewWizardPage;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TranslationBundleNewWizardPage
extends ResourceBundleNewWizardPage {
    protected boolean autoAddFefaultLocale = false;
    private boolean createFolder = false;

    public TranslationBundleNewWizardPage(ISelection selection) {
        super(selection);
    }

    @Override
    protected void createBundleNameArea(Composite container) {
    }

    @Override
    protected void createTopComposite(Composite parent) {
        super.createTopComposite(parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        if (this.getWizard() instanceof TranslateBundleWizard) {
            final Button createFolderButton = new Button(container, 32);
            createFolderButton.setSelection(true);
            createFolderButton.setText(Messages.editor_wiz_createFolder);
            this.createFolder = true;
            createFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TranslationBundleNewWizardPage.this.createFolder = createFolderButton.getSelection();
                }
            });
        }
    }

    @Override
    protected void createBottomComposite(Composite parent) {
        super.createBottomComposite(parent);
        this.bundleLocalesList.removeAll();
    }

    @Override
    public String[] getLocaleStrings() {
        return super.getLocaleStrings();
    }

    @Override
    public String getFileName() {
        return " ";
    }

    public boolean needToCreateFolder() {
        return this.createFolder;
    }

    @Override
    protected void dialogChanged() {
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (!this.isCurrentPage()) {
            this.updateStatus(null, 3);
            return;
        }
        if (container.length() == 0) {
            this.updateStatus(Messages.editor_wiz_error_container, 3);
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.editor_wiz_error_bundleName, 3);
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1) {
            this.updateStatus(Messages.editor_wiz_error_extension, 3);
            return;
        }
        if (this.getLocaleStrings().length == 0) {
            this.updateStatus(Messages.editor_wiz_error_noLocale, 3);
            return;
        }
        IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(container);
        if (!prj.exists()) {
            this.updateStatus(Messages.editor_wiz_error_noPrject, 1);
            return;
        }
        if (!NatureTranslationTester.evaluateElementNature(prj)) {
            this.updateStatus(Messages.editor_wiz_error_wrongType, 3);
            return;
        }
        this.updateStatus(null, 0);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.dialogChanged();
        }
    }

    @Override
    protected String getContextName() {
        return "com.jaspersoft.studio.babel.editor.defineStructureHelp";
    }

    public void addDefaultLocale(String[] exclusionLanguages) {
        if (this.autoAddFefaultLocale) {
            this.addDefaultLocale(exclusionLanguages);
        }
    }
}

