/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.translation.wizard;

import com.jaspersoft.translation.resources.TranslationProjectNature;
import com.jaspersoft.translation.wizard.TranslationProjectPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class TranslationProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    protected TranslationProjectPage step1;

    public TranslationProjectWizard() {
        this.setWindowTitle(Messages.translation_wiz_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.step1 = new TranslationProjectPage();
        this.addPage((IWizardPage)this.step1);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    TranslationProjectWizard.this.doFinish(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void doFinish(IProgressMonitor monitor) {
        IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.step1.getName());
        if (!prj.exists()) {
            IProjectDescription desc = prj.getWorkspace().newProjectDescription(prj.getName());
            try {
                prj.create(desc, null);
                if (!prj.isOpen()) {
                    prj.open(null);
                }
                this.createProject(monitor, prj);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected void createProject(IProgressMonitor monitor, IProject prj) throws CoreException {
        TranslationProjectNature.createJRProject(monitor, prj);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

