/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.checks.proximity;

import org.eclipse.babel.core.message.checks.proximity.IProximityAnalyzer;

public class LevenshteinDistanceAnalyzer
implements IProximityAnalyzer {
    private static final IProximityAnalyzer INSTANCE = new LevenshteinDistanceAnalyzer();

    private LevenshteinDistanceAnalyzer() {
    }

    public static IProximityAnalyzer getInstance() {
        return INSTANCE;
    }

    @Override
    public double analyse(String str1, String str2) {
        int maxLength = Math.max(str1.length(), str2.length());
        double distance = this.distance(str1, str2);
        return 1.0 - distance / (double)maxLength;
    }

    private int minimum(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    public int distance(String s, String t) {
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= n) {
            char s_i = s.charAt(i - 1);
            j = 1;
            while (j <= m) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = this.minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
                ++j;
            }
            ++i;
        }
        return d[n][m];
    }
}

