/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.checks.proximity;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.babel.core.message.checks.proximity.IProximityAnalyzer;

public class WordCountAnalyzer
implements IProximityAnalyzer {
    private static final IProximityAnalyzer INSTANCE = new WordCountAnalyzer();
    private static final String WORD_SPLIT_PATTERN = "\r\n|\r|\n|\\s";

    private WordCountAnalyzer() {
    }

    public static IProximityAnalyzer getInstance() {
        return INSTANCE;
    }

    @Override
    public double analyse(String words1, String words2) {
        ArrayList<String> str1 = new ArrayList<String>(Arrays.asList(words1.split(WORD_SPLIT_PATTERN)));
        ArrayList<String> str2 = new ArrayList<String>(Arrays.asList(words2.split(WORD_SPLIT_PATTERN)));
        int maxWords = Math.max(str1.size(), str2.size());
        if (maxWords == 0) {
            return 0.0;
        }
        int matchedWords = 0;
        for (String str : str1) {
            if (!str2.remove(str)) continue;
            ++matchedWords;
        }
        return (double)matchedWords / (double)maxWords;
    }
}

