/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.internal;

import java.beans.PropertyChangeListener;
import java.util.Locale;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.internal.AbstractMessageModel;

public final class Message
extends AbstractMessageModel
implements IMessage {
    private static final long serialVersionUID = 1160670351341655427L;
    public static final String PROPERTY_COMMENT = "comment";
    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_TEXT = "text";
    private final String key;
    private final Locale locale;
    private String comment;
    private boolean active = true;
    private String text;

    public Message(String key, Locale locale) {
        this.key = key == null ? "" : key;
        this.locale = locale;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public void setComment(String comment, boolean silent) {
        String oldValue = this.comment;
        this.comment = comment;
        if (!silent) {
            this.firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
        }
    }

    @Override
    public void setActive(boolean active) {
        boolean oldValue = this.active;
        this.active = active;
        this.firePropertyChange(PROPERTY_ACTIVE, oldValue, active);
    }

    @Override
    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        this.firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    public void setText(String text, boolean silent) {
        String oldValue = this.text;
        this.text = text;
        if (!silent) {
            this.firePropertyChange(PROPERTY_TEXT, oldValue, text);
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.text;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected void copyFrom(IMessage message) {
        this.setComment(message.getComment());
        this.setActive(message.isActive());
        this.setText(message.getValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Message)) {
            return false;
        }
        Message entry = (Message)obj;
        return this.equals(this.key, entry.key) && this.equals(this.locale, entry.locale) && this.active == entry.active && this.equals(this.text, entry.text) && this.equals(this.comment, entry.comment);
    }

    @Override
    public String toString() {
        return "Message=[[key=" + this.key + "][text=" + this.text + "][comment=" + this.comment + "][active=" + this.active + "]]";
    }

    public final synchronized void addMessageListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(listener);
    }

    public final synchronized void removeMessageListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(listener);
    }

    public final synchronized PropertyChangeListener[] getMessageListeners() {
        return this.getPropertyChangeListeners();
    }

    @Override
    public IMessage clone() {
        Locale newLocale = this.locale != null ? (Locale)this.locale.clone() : null;
        Message newMessage = new Message(new String(this.key), newLocale);
        newMessage.setActive(this.isActive());
        newMessage.setComment(this.getComment() != null ? new String(this.getComment()) : null, true);
        newMessage.setText(this.getValue() != null ? new String(this.getValue()) : null, true);
        return newMessage;
    }
}

