/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.IMessagesResourceChangeListener;
import org.eclipse.babel.core.message.internal.AbstractMessageModel;
import org.eclipse.babel.core.message.internal.IMessagesBundleListener;
import org.eclipse.babel.core.message.internal.Message;
import org.eclipse.babel.core.message.internal.MessageException;
import org.eclipse.babel.core.message.internal.MessagesBundleAdapter;
import org.eclipse.babel.core.message.resource.IMessagesResource;
import org.eclipse.babel.core.util.BabelUtils;

public class MessagesBundle
extends AbstractMessageModel
implements IMessagesResourceChangeListener,
IMessagesBundle {
    private static final long serialVersionUID = -331515196227475652L;
    public static final String PROPERTY_COMMENT = "comment";
    public static final String PROPERTY_MESSAGES_COUNT = "messagesCount";
    private static final IMessagesBundleListener[] EMPTY_MSG_BUNDLE_LISTENERS = new IMessagesBundleListener[0];
    private final Collection<String> orderedKeys = new ArrayList<String>();
    private final Map<String, IMessage> keyedMessages = new HashMap<String, IMessage>();
    private final IMessagesResource resource;
    private final PropertyChangeListener messageListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            MessagesBundle.this.fireMessageChanged(event);
        }
    };
    private String comment;

    public MessagesBundle(IMessagesResource resource) {
        this.resource = resource;
        this.readFromResource();
        resource.addMessagesResourceChangeListener(new IMessagesResourceChangeListener(){

            @Override
            public void resourceChanged(IMessagesResource changedResource) {
                MessagesBundle.this.readFromResource();
            }
        });
        this.addMessagesBundleListener(new MessagesBundleAdapter(){

            @Override
            public void messageChanged(MessagesBundle messagesBundle, PropertyChangeEvent changeEvent) {
                MessagesBundle.this.writetoResource();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MessagesBundle.this.writetoResource();
            }
        });
    }

    @Override
    public void dispose() {
        this.resource.dispose();
    }

    @Override
    public IMessagesResource getResource() {
        return this.resource;
    }

    public int getMessagesCount() {
        return this.keyedMessages.size();
    }

    @Override
    public Locale getLocale() {
        return this.resource.getLocale();
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public void resourceChanged(IMessagesResource changedResource) {
        this.resource.deserialize(this);
    }

    @Override
    public void addMessage(IMessage message) {
        Message m = (Message)message;
        int oldCount = this.getMessagesCount();
        if (!this.orderedKeys.contains(m.getKey())) {
            this.orderedKeys.add(m.getKey());
        }
        if (!this.keyedMessages.containsKey(m.getKey())) {
            this.keyedMessages.put(m.getKey(), m);
            m.addMessageListener(this.messageListener);
            this.firePropertyChange(PROPERTY_MESSAGES_COUNT, oldCount, this.getMessagesCount());
            this.fireMessageAdded(m);
        } else {
            Message matchingEntry = (Message)this.keyedMessages.get(m.getKey());
            matchingEntry.copyFrom(m);
        }
    }

    @Override
    public void removeMessage(String messageKey) {
        int oldCount = this.getMessagesCount();
        this.orderedKeys.remove(messageKey);
        Message message = (Message)this.keyedMessages.get(messageKey);
        if (message != null) {
            message.removePropertyChangeListener(this.messageListener);
            this.keyedMessages.remove(messageKey);
            this.firePropertyChange(PROPERTY_MESSAGES_COUNT, oldCount, this.getMessagesCount());
            this.fireMessageRemoved(message);
        }
    }

    @Override
    public void removeMessageAddParentKey(String messageKey) {
        this.removeMessage(messageKey);
        int index = messageKey.lastIndexOf(".");
        String string = messageKey = index == -1 ? "" : messageKey.substring(0, index);
        if (!messageKey.isEmpty()) {
            this.addMessage(new Message(messageKey, this.getLocale()));
        }
    }

    @Override
    public void removeMessages(String[] messageKeys) {
        int i = 0;
        while (i < messageKeys.length) {
            this.removeMessage(messageKeys[i]);
            ++i;
        }
    }

    @Override
    public void renameMessageKey(String sourceKey, String targetKey) {
        if (this.getMessage(targetKey) != null) {
            throw new MessageException("Cannot rename: target key already exists.");
        }
        IMessage sourceEntry = this.getMessage(sourceKey);
        if (sourceEntry != null) {
            Message targetEntry = new Message(targetKey, this.getLocale());
            targetEntry.copyFrom(sourceEntry);
            this.removeMessage(sourceKey);
            this.addMessage(targetEntry);
        }
    }

    @Override
    public void duplicateMessage(String sourceKey, String targetKey) {
        if (this.getMessage(sourceKey) != null) {
            throw new MessageException("Cannot duplicate: target key already exists.");
        }
        IMessage sourceEntry = this.getMessage(sourceKey);
        if (sourceEntry != null) {
            Message targetEntry = new Message(targetKey, this.getLocale());
            targetEntry.copyFrom(sourceEntry);
            this.addMessage(targetEntry);
        }
    }

    @Override
    public IMessage getMessage(String key) {
        return this.keyedMessages.get(key);
    }

    public void addMessage(String key) {
        this.addMessage(new Message(key, this.getLocale()));
    }

    @Override
    public String[] getKeys() {
        return this.orderedKeys.toArray(BabelUtils.EMPTY_STRINGS);
    }

    @Override
    public Collection<IMessage> getMessages() {
        return this.keyedMessages.values();
    }

    public String toString() {
        String str = "MessagesBundle=[[locale=" + this.getLocale() + "][comment=" + this.comment + "][entries=";
        for (IMessage message : this.getMessages()) {
            str = String.valueOf(str) + message.toString();
        }
        str = String.valueOf(str) + "]]";
        return str;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.messageListener == null ? 0 : this.messageListener.hashCode());
        result = 31 * result + (this.keyedMessages == null ? 0 : this.keyedMessages.hashCode());
        result = 31 * result + (this.orderedKeys == null ? 0 : this.orderedKeys.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MessagesBundle)) {
            return false;
        }
        MessagesBundle messagesBundle = (MessagesBundle)obj;
        return this.equals(this.comment, messagesBundle.comment) && this.equals(this.keyedMessages, messagesBundle.keyedMessages);
    }

    public final synchronized void addMessagesBundleListener(IMessagesBundleListener listener) {
        this.addPropertyChangeListener(listener);
    }

    public final synchronized void removeMessagesBundleListener(IMessagesBundleListener listener) {
        this.removePropertyChangeListener(listener);
    }

    public final synchronized IMessagesBundleListener[] getMessagesBundleListeners() {
        return Arrays.asList(this.getPropertyChangeListeners()).toArray(EMPTY_MSG_BUNDLE_LISTENERS);
    }

    private void readFromResource() {
        this.resource.deserialize(this);
    }

    private void writetoResource() {
        this.resource.serialize(this);
    }

    private void fireMessageAdded(Message message) {
        IMessagesBundleListener[] listeners = this.getMessagesBundleListeners();
        int i = 0;
        while (i < listeners.length) {
            IMessagesBundleListener listener = listeners[i];
            listener.messageAdded(this, message);
            ++i;
        }
    }

    private void fireMessageRemoved(Message message) {
        IMessagesBundleListener[] listeners = this.getMessagesBundleListeners();
        int i = 0;
        while (i < listeners.length) {
            IMessagesBundleListener listener = listeners[i];
            listener.messageRemoved(this, message);
            ++i;
        }
    }

    private void fireMessageChanged(PropertyChangeEvent event) {
        IMessagesBundleListener[] listeners = this.getMessagesBundleListeners();
        int i = 0;
        while (i < listeners.length) {
            IMessagesBundleListener listener = listeners[i];
            listener.messageChanged(this, event);
            ++i;
        }
    }

    @Override
    public String getValue(String key) {
        return this.getMessage(key).getValue();
    }
}

