/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.babel.core.configuration.DirtyHack;
import org.eclipse.babel.core.factory.MessagesBundleGroupFactory;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.IMessagesBundleGroup;
import org.eclipse.babel.core.message.internal.Message;
import org.eclipse.babel.core.message.manager.IMessagesEditorListener;
import org.eclipse.babel.core.message.manager.IResourceDeltaListener;
import org.eclipse.babel.core.message.manager.ResourceBundleDetectionVisitor;
import org.eclipse.babel.core.refactoring.IRefactoringService;
import org.eclipse.babel.core.refactoring.StandardRefactoring;
import org.eclipse.babel.core.util.FileUtils;
import org.eclipse.babel.core.util.NameUtils;
import org.eclipse.babel.core.util.PDEUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public final class RBManager {
    private static Map<IProject, RBManager> managerMap = new HashMap<IProject, RBManager>();
    private final Map<String, IMessagesBundleGroup> resourceBundles = new HashMap<String, IMessagesBundleGroup>();
    private static RBManager INSTANCE;
    private final List<IMessagesEditorListener> editorListeners = new ArrayList<IMessagesEditorListener>(3);
    private final List<IResourceDeltaListener> resourceListeners = new ArrayList<IResourceDeltaListener>(2);
    private IProject project;
    private static final String TAPIJI_NATURE = "org.eclipse.babel.tapiji.tools.core.ui.nature";
    static final Logger logger;
    private static IRefactoringService refactorService;

    static {
        logger = Logger.getLogger(RBManager.class.getName());
    }

    private RBManager() {
    }

    public IMessagesBundleGroup getMessagesBundleGroup(String resourceBundleId) {
        if (!this.resourceBundles.containsKey(resourceBundleId)) {
            logger.log(Level.SEVERE, "getMessagesBundleGroup with non-existing Id: " + resourceBundleId);
            return null;
        }
        return this.resourceBundles.get(resourceBundleId);
    }

    public List<String> getMessagesBundleGroupNames() {
        ArrayList<String> bundleGroupNames = new ArrayList<String>();
        for (String key : this.resourceBundles.keySet()) {
            bundleGroupNames.add(String.valueOf(this.project.getName()) + "/" + key);
        }
        return bundleGroupNames;
    }

    public static List<String> getAllMessagesBundleGroupNames() {
        ArrayList<String> bundleGroupNames = new ArrayList<String>();
        for (IProject project : RBManager.getAllSupportedProjects()) {
            RBManager manager = RBManager.getInstance(project);
            for (String name : manager.getMessagesBundleGroupNames()) {
                if (bundleGroupNames.contains(name)) continue;
                bundleGroupNames.add(name);
            }
        }
        return bundleGroupNames;
    }

    public void notifyMessagesBundleGroupCreated(IMessagesBundleGroup bundleGroup) {
        if (this.resourceBundles.containsKey(bundleGroup.getResourceBundleId())) {
            IMessagesBundleGroup oldbundleGroup = this.resourceBundles.get(bundleGroup.getResourceBundleId());
            if (!this.equalHash(oldbundleGroup, bundleGroup)) {
                boolean oldHasPropertiesStrategy = oldbundleGroup.hasPropertiesFileGroupStrategy();
                boolean newHasPropertiesStrategy = bundleGroup.hasPropertiesFileGroupStrategy();
                if (oldHasPropertiesStrategy && !newHasPropertiesStrategy) {
                    this.syncBundles(bundleGroup, oldbundleGroup);
                    this.resourceBundles.put(bundleGroup.getResourceBundleId(), bundleGroup);
                    logger.log(Level.INFO, "sync: " + bundleGroup.getResourceBundleId() + " with " + oldbundleGroup.getResourceBundleId());
                    oldbundleGroup.dispose();
                } else if (oldHasPropertiesStrategy && newHasPropertiesStrategy || !oldHasPropertiesStrategy && !newHasPropertiesStrategy) {
                    this.resourceBundles.put(bundleGroup.getResourceBundleId(), bundleGroup);
                    logger.log(Level.INFO, "replace: " + bundleGroup.getResourceBundleId() + " with " + oldbundleGroup.getResourceBundleId());
                    oldbundleGroup.dispose();
                } else {
                    logger.log(Level.INFO, "dispose: " + bundleGroup.getResourceBundleId());
                    bundleGroup.dispose();
                }
            }
        } else {
            this.resourceBundles.put(bundleGroup.getResourceBundleId(), bundleGroup);
            logger.log(Level.INFO, "add: " + bundleGroup.getResourceBundleId());
        }
    }

    public void notifyMessagesBundleGroupDeleted(IMessagesBundleGroup bundleGroup) {
        if (this.resourceBundles.containsKey(bundleGroup.getResourceBundleId()) && this.equalHash(this.resourceBundles.get(bundleGroup.getResourceBundleId()), bundleGroup)) {
            this.resourceBundles.remove(bundleGroup.getResourceBundleId());
            for (IResourceDeltaListener deltaListener : this.resourceListeners) {
                deltaListener.onDelete(bundleGroup);
            }
        }
    }

    public void notifyResourceRemoved(IResource resourceBundle) {
        String resourceBundleId = NameUtils.getResourceBundleId(resourceBundle);
        IMessagesBundleGroup bundleGroup = this.resourceBundles.get(resourceBundleId);
        if (bundleGroup != null) {
            Locale locale = NameUtils.getLocaleByName(NameUtils.getResourceBundleName(resourceBundle), resourceBundle.getName());
            IMessagesBundle messagesBundle = bundleGroup.getMessagesBundle(locale);
            if (messagesBundle != null) {
                bundleGroup.removeMessagesBundle(messagesBundle);
            }
            for (IResourceDeltaListener deltaListener : this.resourceListeners) {
                deltaListener.onDelete(resourceBundleId, resourceBundle);
            }
            if (bundleGroup.getMessagesBundleCount() == 0) {
                this.notifyMessagesBundleGroupDeleted(bundleGroup);
            }
        }
    }

    private boolean equalHash(IMessagesBundleGroup oldBundleGroup, IMessagesBundleGroup newBundleGroup) {
        return oldBundleGroup.hashCode() == newBundleGroup.hashCode();
    }

    private void syncBundles(IMessagesBundleGroup oldBundleGroup, IMessagesBundleGroup newBundleGroup) {
        ArrayList<IMessagesBundle> bundlesToRemove = new ArrayList<IMessagesBundle>();
        ArrayList<IMessage> keysToRemove = new ArrayList<IMessage>();
        DirtyHack.setFireEnabled(false);
        for (IMessagesBundle newBundle : newBundleGroup.getMessagesBundles()) {
            IMessagesBundle oldBundle = oldBundleGroup.getMessagesBundle(newBundle.getLocale());
            if (oldBundle == null) {
                oldBundleGroup.addMessagesBundle(newBundle.getLocale(), newBundle);
                continue;
            }
            for (IMessage newMsg : newBundle.getMessages()) {
                if (oldBundle.getMessage(newMsg.getKey()) == null) {
                    oldBundle.addMessage(new Message(newMsg.getKey(), newMsg.getLocale()));
                    continue;
                }
                IMessage oldMsg = oldBundle.getMessage(newMsg.getKey());
                if (oldMsg == null) {
                    oldBundle.addMessage(newMsg);
                    continue;
                }
                oldMsg.setComment(newMsg.getComment());
                oldMsg.setText(newMsg.getValue());
            }
        }
        for (IMessagesBundle oldBundle : oldBundleGroup.getMessagesBundles()) {
            IMessagesBundle newBundle = newBundleGroup.getMessagesBundle(oldBundle.getLocale());
            if (newBundle == null) {
                bundlesToRemove.add(oldBundle);
                continue;
            }
            for (IMessage oldMsg : oldBundle.getMessages()) {
                if (newBundle.getMessage(oldMsg.getKey()) != null) continue;
                keysToRemove.add(oldMsg);
            }
        }
        for (IMessagesBundle bundle : bundlesToRemove) {
            oldBundleGroup.removeMessagesBundle(bundle);
        }
        for (IMessage msg : keysToRemove) {
            IMessagesBundle mb = oldBundleGroup.getMessagesBundle(msg.getLocale());
            if (mb == null) continue;
            mb.removeMessage(msg.getKey());
        }
        DirtyHack.setFireEnabled(true);
    }

    public void deleteMessagesBundleGroup(String resourceBundleId) {
        if (this.resourceBundles.containsKey(resourceBundleId)) {
            this.resourceBundles.remove(resourceBundleId);
        } else {
            logger.log(Level.SEVERE, "deleteMessagesBundleGroup with non-existing Id: " + resourceBundleId);
        }
    }

    public boolean containsMessagesBundleGroup(String resourceBundleId) {
        return this.resourceBundles.containsKey(resourceBundleId);
    }

    public static RBManager getInstance(IProject project) {
        if (PDEUtils.isFragment(project)) {
            project = PDEUtils.getFragmentHost(project);
        }
        if ((INSTANCE = managerMap.get(project)) == null) {
            INSTANCE = new RBManager();
            RBManager.INSTANCE.project = project;
            managerMap.put(project, INSTANCE);
            refactorService = RBManager.getRefactoringService();
        }
        return INSTANCE;
    }

    public static RBManager getInstance(String projectName) {
        for (IProject project : RBManager.getAllWorkspaceProjects(true)) {
            if (!project.getName().equals(projectName)) continue;
            if (PDEUtils.isFragment(project)) {
                return RBManager.getInstance(PDEUtils.getFragmentHost(project));
            }
            return RBManager.getInstance(project);
        }
        return null;
    }

    public static Set<IProject> getAllWorkspaceProjects(boolean ignoreNature) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IProject> projs = new HashSet<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                if (p.isOpen() && (ignoreNature || p.hasNature(TAPIJI_NATURE))) {
                    projs.add(p);
                }
            }
            catch (CoreException e) {
                logger.log(Level.SEVERE, "getAllWorkspaceProjects(...): hasNature failed!", e);
            }
            ++n2;
        }
        return projs;
    }

    public static Set<IProject> getAllSupportedProjects() {
        return RBManager.getAllWorkspaceProjects(false);
    }

    public void addMessagesEditorListener(IMessagesEditorListener listener) {
        this.editorListeners.add(listener);
    }

    public void removeMessagesEditorListener(IMessagesEditorListener listener) {
        this.editorListeners.remove(listener);
    }

    public void addResourceDeltaListener(IResourceDeltaListener listener) {
        this.resourceListeners.add(listener);
    }

    public void removeResourceDeltaListener(IResourceDeltaListener listener) {
        this.resourceListeners.remove(listener);
    }

    public void fireEditorSaved() {
        for (IMessagesEditorListener listener : this.editorListeners) {
            listener.onSave();
        }
        logger.log(Level.INFO, "fireEditorSaved");
    }

    public void fireEditorChanged() {
        for (IMessagesEditorListener listener : this.editorListeners) {
            listener.onModify();
        }
        logger.log(Level.INFO, "fireEditorChanged");
    }

    public void fireResourceChanged(IMessagesBundle bundle) {
        for (IMessagesEditorListener listener : this.editorListeners) {
            listener.onResourceChanged(bundle);
        }
    }

    @Deprecated
    protected void detectResourceBundles() {
        try {
            this.project.accept((IResourceVisitor)new ResourceBundleDetectionVisitor(this));
            IProject[] fragments = PDEUtils.lookupFragment(this.project);
            if (fragments != null) {
                IProject[] iProjectArray = fragments;
                int n = fragments.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    p.accept((IResourceVisitor)new ResourceBundleDetectionVisitor(this));
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, "detectResourceBundles: accept failed!", e);
        }
    }

    public void addBundleResource(IResource resource) {
        String resourceBundleId = NameUtils.getResourceBundleId(resource);
        if (!this.resourceBundles.containsKey(resourceBundleId)) {
            MessagesBundleGroupFactory.createBundleGroup(resource);
            logger.log(Level.INFO, "addBundleResource (passive loading): " + resourceBundleId + " (" + resource.getName() + ")");
        }
    }

    public void writeToFile(IMessagesBundleGroup bundleGroup) {
        for (IMessagesBundle bundle : bundleGroup.getMessagesBundles()) {
            FileUtils.writeToFile(bundle);
            this.fireResourceChanged(bundle);
        }
    }

    private static IRefactoringService getRefactoringService() {
        IConfigurationElement[] elements;
        IExtensionPoint extp = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.babel.core.refactoringService");
        if (extp != null && (elements = extp.getConfigurationElements()).length != 0) {
            try {
                return (IRefactoringService)elements[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return new StandardRefactoring();
    }

    public static IRefactoringService getRefactorService() {
        return refactorService;
    }
}

