/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.resource.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.babel.core.message.internal.AbstractIFileChangeListener;
import org.eclipse.babel.core.message.resource.internal.AbstractPropertiesResource;
import org.eclipse.babel.core.message.resource.ser.PropertiesDeserializer;
import org.eclipse.babel.core.message.resource.ser.PropertiesSerializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;

public class PropertiesIFileResource
extends AbstractPropertiesResource {
    private final IFile file;
    private final AbstractIFileChangeListener fileListener;
    private final AbstractIFileChangeListener.IFileChangeListenerRegistry listenerRegistry;

    public PropertiesIFileResource(Locale locale, PropertiesSerializer serializer, PropertiesDeserializer deserializer, IFile file, AbstractIFileChangeListener.IFileChangeListenerRegistry listenerRegistry) {
        super(locale, serializer, deserializer);
        this.file = file;
        this.listenerRegistry = listenerRegistry;
        if (this.listenerRegistry != null) {
            IResourceChangeListener rcl = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    PropertiesIFileResource.this.fireResourceChange(PropertiesIFileResource.this);
                }
            };
            this.fileListener = AbstractIFileChangeListener.wrapResourceChangeListener(rcl, file);
            this.listenerRegistry.subscribe(this.fileListener);
        } else {
            this.fileListener = null;
        }
    }

    @Override
    public String getText() {
        try {
            this.file.refreshLocal(2, null);
            InputStream is = this.file.getContents();
            int byteCount = is.available();
            byte[] b = new byte[byteCount];
            is.read(b);
            String content = new String(b, this.file.getCharset());
            return content;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setText(String text) {
        try {
            String charset = this.file.getCharset();
            ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes(charset));
            this.file.setContents((InputStream)is, 2, null);
            this.file.refreshLocal(0, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot set content on properties file.", e);
        }
    }

    @Override
    public Object getSource() {
        return this.file;
    }

    @Override
    public String getResourceLocationLabel() {
        return this.file.getFullPath().toString();
    }

    @Override
    public void dispose() {
        if (this.listenerRegistry != null) {
            this.listenerRegistry.unsubscribe(this.fileListener);
        }
    }
}

