/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.tree.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.internal.MessagesBundleGroupAdapter;
import org.eclipse.babel.core.message.tree.IAbstractKeyTreeModel;
import org.eclipse.babel.core.message.tree.IKeyTreeNode;
import org.eclipse.babel.core.message.tree.IKeyTreeVisitor;
import org.eclipse.babel.core.message.tree.internal.IKeyTreeModelListener;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;

public class AbstractKeyTreeModel
implements IAbstractKeyTreeModel {
    private List<IKeyTreeModelListener> listeners = new ArrayList<IKeyTreeModelListener>();
    private Comparator<IKeyTreeNode> comparator;
    private KeyTreeNode rootNode = new KeyTreeNode(null, null, null, null);
    private String delimiter;
    private MessagesBundleGroup messagesBundleGroup;
    protected static final KeyTreeNode[] EMPTY_NODES = new KeyTreeNode[0];

    public AbstractKeyTreeModel(MessagesBundleGroup messagesBundleGroup) {
        this(messagesBundleGroup, ".");
    }

    public void dispose() {
        this.listeners.clear();
    }

    public AbstractKeyTreeModel(MessagesBundleGroup messagesBundleGroup, String delimiter) {
        this.messagesBundleGroup = messagesBundleGroup;
        this.delimiter = delimiter;
        this.createTree();
        messagesBundleGroup.addMessagesBundleGroupListener(new MessagesBundleGroupAdapter(){

            @Override
            public void keyAdded(String key) {
                AbstractKeyTreeModel.this.createTreeNodes(key);
            }

            @Override
            public void keyRemoved(String key) {
                AbstractKeyTreeModel.this.removeTreeNodes(key);
            }
        });
    }

    public void addKeyTreeModelListener(IKeyTreeModelListener listener) {
        this.listeners.add(0, listener);
    }

    public void removeKeyTreeModelListener(IKeyTreeModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireNodeAdded(KeyTreeNode node) {
        for (IKeyTreeModelListener listener : this.listeners) {
            listener.nodeAdded(node);
        }
    }

    protected void fireNodeRemoved(KeyTreeNode node) {
        for (IKeyTreeModelListener listener : this.listeners) {
            listener.nodeRemoved(node);
        }
    }

    public KeyTreeNode[] getBranch(KeyTreeNode parentNode) {
        return parentNode.getBranch().toArray(new KeyTreeNode[0]);
    }

    @Override
    public void accept(IKeyTreeVisitor visitor, IKeyTreeNode node) {
        if (node == null) {
            return;
        }
        if (node != null) {
            visitor.visitKeyTreeNode(node);
        }
        IKeyTreeNode[] nodes = this.getChildren(node);
        int i = 0;
        while (i < nodes.length) {
            this.accept(visitor, nodes[i]);
            ++i;
        }
    }

    @Override
    public IKeyTreeNode[] getChildren(IKeyTreeNode node) {
        if (node == null) {
            return null;
        }
        IKeyTreeNode[] nodes = node.getChildren();
        if (this.getComparator() != null) {
            Arrays.sort(nodes, this.getComparator());
        }
        return nodes;
    }

    public Comparator<IKeyTreeNode> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<IKeyTreeNode> comparator) {
        this.comparator = comparator;
    }

    public boolean isBranchFiltered(IKeyTreeNodeLeafFilter filter, IKeyTreeNode node) {
        if (!((KeyTreeNode)node).hasChildren()) {
            return filter.isFilteredLeaf(node);
        }
        for (IKeyTreeNode childNode : ((KeyTreeNode)node).getChildrenInternal()) {
            if (!this.isBranchFiltered(filter, childNode)) continue;
            return true;
        }
        return false;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public IKeyTreeNode[] getRootNodes() {
        return this.getChildren(this.rootNode);
    }

    @Override
    public IKeyTreeNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public IKeyTreeNode getParent(IKeyTreeNode node) {
        return node.getParent();
    }

    public MessagesBundleGroup getMessagesBundleGroup() {
        return this.messagesBundleGroup;
    }

    private void createTree() {
        this.rootNode = new KeyTreeNode(null, null, null, this.messagesBundleGroup);
        String[] keys = this.messagesBundleGroup.getMessageKeys();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            this.createTreeNodes(key);
            ++i;
        }
    }

    private void createTreeNodes(String bundleKey) {
        StringTokenizer tokens = new StringTokenizer(bundleKey, this.delimiter);
        KeyTreeNode node = this.rootNode;
        String bundleKeyPart = "";
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            bundleKeyPart = String.valueOf(bundleKeyPart) + name;
            KeyTreeNode child = (KeyTreeNode)node.getChild(name);
            if (child == null) {
                child = new KeyTreeNode(node, name, bundleKeyPart, this.messagesBundleGroup);
                this.fireNodeAdded(child);
            }
            bundleKeyPart = String.valueOf(bundleKeyPart) + this.delimiter;
            node = child;
        }
        node.setUsedAsKey();
    }

    private void removeTreeNodes(String bundleKey) {
        if (bundleKey == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(bundleKey, this.delimiter);
        KeyTreeNode node = this.rootNode;
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            if ((node = (KeyTreeNode)node.getChild(name)) != null) continue;
            System.err.println("No RegEx node matching bundleKey to remove");
            return;
        }
        KeyTreeNode parentNode = (KeyTreeNode)node.getParent();
        parentNode.removeChild(node);
        this.fireNodeRemoved(node);
        while (parentNode != this.rootNode) {
            if (!parentNode.hasChildren() && !this.messagesBundleGroup.isMessageKey(parentNode.getMessageKey())) {
                ((KeyTreeNode)parentNode.getParent()).removeChild(parentNode);
                this.fireNodeRemoved(parentNode);
            }
            parentNode = (KeyTreeNode)parentNode.getParent();
        }
    }

    @Override
    public IKeyTreeNode getChild(String key) {
        return this.returnNodeWithKey(key, this.rootNode);
    }

    private IKeyTreeNode returnNodeWithKey(String key, IKeyTreeNode node) {
        if (!key.equals(node.getMessageKey())) {
            IKeyTreeNode[] iKeyTreeNodeArray = node.getChildren();
            int n = iKeyTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyTreeNode n3 = iKeyTreeNodeArray[n2];
                IKeyTreeNode returnNode = this.returnNodeWithKey(key, n3);
                if (returnNode != null) {
                    return returnNode;
                }
                ++n2;
            }
        } else {
            return node;
        }
        return null;
    }

    public static interface IKeyTreeNodeLeafFilter {
        public boolean isFilteredLeaf(IKeyTreeNode var1);
    }
}

