/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.babel.core.util.FileChangeListener;

public class FileMonitor {
    private static final FileMonitor instance = new FileMonitor();
    private Timer timer = new Timer(true);
    private Hashtable<String, FileMonitorTask> timerEntries = new Hashtable();

    public static FileMonitor getInstance() {
        return instance;
    }

    private FileMonitor() {
    }

    public void addFileChangeListener(FileChangeListener listener, String fileName, long period) throws FileNotFoundException {
        this.addFileChangeListener(listener, new File(fileName), period);
    }

    public void addFileChangeListener(FileChangeListener listener, File file, long period) throws FileNotFoundException {
        this.removeFileChangeListener(listener, file);
        FileMonitorTask task = new FileMonitorTask(listener, file);
        this.timerEntries.put(String.valueOf(file.toString()) + listener.hashCode(), task);
        this.timer.schedule((TimerTask)task, period, period);
    }

    public void removeFileChangeListener(FileChangeListener listener, String fileName) {
        this.removeFileChangeListener(listener, new File(fileName));
    }

    public void removeFileChangeListener(FileChangeListener listener, File file) {
        FileMonitorTask task = this.timerEntries.remove(String.valueOf(file.toString()) + listener.hashCode());
        if (task != null) {
            task.cancel();
        }
    }

    protected void fireFileChangeEvent(FileChangeListener listener, File file) {
        listener.fileChanged(file);
    }

    class FileMonitorTask
    extends TimerTask {
        FileChangeListener listener;
        File monitoredFile;
        long lastModified;

        public FileMonitorTask(FileChangeListener listener, File file) throws FileNotFoundException {
            this.listener = listener;
            this.lastModified = 0L;
            this.monitoredFile = file;
            if (!this.monitoredFile.exists()) {
                URL fileURL = listener.getClass().getClassLoader().getResource(file.toString());
                if (fileURL != null) {
                    this.monitoredFile = new File(fileURL.getFile());
                } else {
                    throw new FileNotFoundException("File Not Found: " + file);
                }
            }
            this.lastModified = this.monitoredFile.lastModified();
        }

        @Override
        public void run() {
            long lastModified = this.monitoredFile.lastModified();
            if (lastModified != this.lastModified) {
                this.lastModified = lastModified;
                FileMonitor.this.fireFileChangeEvent(this.listener, this.monitoredFile);
            }
        }
    }
}

