/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.babel.core.configuration.ConfigurationManager;
import org.eclipse.babel.core.configuration.DirtyHack;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.resource.internal.PropertiesFileResource;
import org.eclipse.babel.core.message.resource.ser.PropertiesSerializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;

public class FileUtils {
    public static void writeToFile(IMessagesBundle bundle) {
        DirtyHack.setEditorModificationEnabled(false);
        PropertiesSerializer ps = new PropertiesSerializer(ConfigurationManager.getInstance().getSerializerConfig());
        String editorContent = ps.serialize(bundle);
        IFile file = FileUtils.getFile(bundle);
        try {
            try {
                file.refreshLocal(0, null);
                file.setContents((InputStream)new ByteArrayInputStream(editorContent.getBytes()), false, true, null);
                file.refreshLocal(0, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                DirtyHack.setEditorModificationEnabled(true);
            }
        }
        finally {
            DirtyHack.setEditorModificationEnabled(true);
        }
    }

    public static IFile getFile(IMessagesBundle bundle) {
        if (bundle.getResource() instanceof PropertiesFileResource) {
            String path = bundle.getResource().getResourceLocationLabel();
            int index = path.indexOf("src");
            String pathBeforeSrc = path.substring(0, index - 1);
            int lastIndexOf = pathBeforeSrc.lastIndexOf(File.separatorChar);
            String projectName = path.substring(lastIndexOf + 1, index - 1);
            String relativeFilePath = path.substring(index, path.length());
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(relativeFilePath);
        }
        String location = bundle.getResource().getResourceLocationLabel();
        String projectName = location.substring(1, location.indexOf("/", 1));
        location = location.substring(projectName.length() + 1, location.length());
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(location);
    }
}

