/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.i18n;

import java.util.Collection;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.babel.core.message.checks.IMessageCheck;
import org.eclipse.babel.core.message.checks.internal.DuplicateValueCheck;
import org.eclipse.babel.core.message.checks.internal.MissingValueCheck;
import org.eclipse.babel.editor.IMessagesEditorChangeListener;
import org.eclipse.babel.editor.i18n.AbstractI18NEntry;
import org.eclipse.babel.editor.i18n.actions.ShowDuplicateAction;
import org.eclipse.babel.editor.i18n.actions.ShowMissingAction;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.internal.MessagesEditorChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class EntryRightBanner
extends Composite {
    private Label colon;
    private Label warningIcon;
    private final ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
    private final AbstractMessagesEditor editor;
    private final Locale locale;
    private final Observer observer = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            EntryRightBanner.this.updateMarkers();
        }
    };
    private final IMessagesEditorChangeListener msgEditorChangeListener = new MessagesEditorChangeAdapter(){

        @Override
        public void selectedKeyChanged(String oldKey, String newKey) {
            EntryRightBanner.this.updateMarkers();
        }
    };

    public EntryRightBanner(Composite parent, AbstractI18NEntry i18nEntry) {
        super(parent, 0);
        this.locale = i18nEntry.getLocale();
        this.editor = i18nEntry.getResourceBundleEditor();
        RowLayout layout = new RowLayout();
        this.setLayout((Layout)layout);
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        this.warningIcon = new Label((Composite)this, 0);
        this.warningIcon.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.warningIcon.setVisible(false);
        this.warningIcon.setToolTipText("This locale has warnings.");
        this.colon = new Label((Composite)this, 0);
        this.colon.setText(":");
        this.colon.setVisible(false);
        this.toolBarMgr.createControl((Composite)this);
        this.toolBarMgr.update(true);
        this.editor.addChangeListener(this.msgEditorChangeListener);
        this.editor.getMarkers().addObserver(this.observer);
    }

    private void updateMarkers() {
        Display display;
        if (!this.toolBarMgr.getControl().isDisposed() && (display = this.toolBarMgr.getControl().getDisplay()).equals(Display.getCurrent()) && !this.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (EntryRightBanner.this.isDisposed()) {
                        return;
                    }
                    boolean isMarked = false;
                    EntryRightBanner.this.toolBarMgr.removeAll();
                    String key = EntryRightBanner.this.editor.getSelectedKey();
                    Collection<IMessageCheck> checks = EntryRightBanner.this.editor.getMarkers().getFailedChecks(key, EntryRightBanner.this.locale);
                    if (checks != null) {
                        for (IMessageCheck check : checks) {
                            Action action = EntryRightBanner.this.getCheckAction(key, check);
                            if (action == null) continue;
                            EntryRightBanner.this.toolBarMgr.add((IAction)action);
                            EntryRightBanner.this.toolBarMgr.update(true);
                            EntryRightBanner.this.getParent().layout(true, true);
                            isMarked = true;
                        }
                    }
                    EntryRightBanner.this.toolBarMgr.update(true);
                    EntryRightBanner.this.getParent().layout(true, true);
                    EntryRightBanner.this.warningIcon.setVisible(isMarked);
                    EntryRightBanner.this.colon.setVisible(isMarked);
                }
            });
        }
    }

    private Action getCheckAction(String key, IMessageCheck check) {
        if (check instanceof MissingValueCheck) {
            return new ShowMissingAction(key, this.locale);
        }
        if (check instanceof DuplicateValueCheck) {
            return new ShowDuplicateAction(((DuplicateValueCheck)check).getDuplicateKeys(), key, this.locale);
        }
        return null;
    }

    public void dispose() {
        this.editor.removeChangeListener(this.msgEditorChangeListener);
        this.editor.getMarkers().deleteObserver(this.observer);
        super.dispose();
    }
}

