/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.i18n;

import org.eclipse.babel.editor.i18n.SideNavTextBoxComposite;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.tree.actions.CollapseAllAction;
import org.eclipse.babel.editor.tree.actions.ExpandAllAction;
import org.eclipse.babel.editor.tree.actions.FlatModelAction;
import org.eclipse.babel.editor.tree.actions.TreeModelAction;
import org.eclipse.babel.editor.tree.internal.KeyTreeContributor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class SideNavComposite
extends Composite {
    private TreeViewer treeViewer;
    private AbstractMessagesEditor editor;
    private SideNavTextBoxComposite textBoxComp;
    private KeyTreeContributor treeContributor;
    private Text filterTextBox;

    public SideNavComposite(Composite parent, AbstractMessagesEditor editor) {
        super(parent, 2048);
        this.editor = editor;
        this.setLayout((Layout)new GridLayout(1, false));
        Composite toolBarComposite = new Composite((Composite)this, 0);
        GridLayout toolbarLayout = new GridLayout(2, false);
        toolbarLayout.marginWidth = 0;
        toolBarComposite.setLayout((Layout)toolbarLayout);
        toolBarComposite.setLayoutData((Object)new GridData(768));
        this.filterTextBox = new Text(toolBarComposite, 2048);
        this.filterTextBox.setLayoutData((Object)new GridData(768));
        this.filterTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SideNavComposite.this.treeContributor.filterKeyItems(SideNavComposite.this.filterTextBox.getText());
                SideNavComposite.this.treeViewer.getControl().setRedraw(false);
                SideNavComposite.this.treeViewer.refresh();
                if (!SideNavComposite.this.filterTextBox.getText().isEmpty()) {
                    SideNavComposite.this.treeViewer.expandAll();
                }
                SideNavComposite.this.treeViewer.getControl().setRedraw(true);
            }
        });
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarMgr.createControl(toolBarComposite);
        this.treeViewer = new TreeViewer((Composite)this, 2820);
        GridData gid = new GridData();
        gid.horizontalAlignment = 3;
        gid.verticalAlignment = 1;
        toolBar.setLayoutData((Object)gid);
        toolBarMgr.add((IAction)new TreeModelAction(editor, this.treeViewer));
        toolBarMgr.add((IAction)new FlatModelAction(editor, this.treeViewer));
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)new ExpandAllAction(editor, this.treeViewer));
        toolBarMgr.add((IAction)new CollapseAllAction(editor, this.treeViewer));
        toolBarMgr.update(true);
        this.createKeyTree();
        this.textBoxComp = new SideNavTextBoxComposite(this, editor);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void dispose() {
        this.treeContributor.dispose();
        super.dispose();
    }

    private void createKeyTree() {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.treeContributor = new KeyTreeContributor(this.editor);
        this.treeContributor.contribute(this.treeViewer);
        this.treeViewer.getTree().setLayoutData((Object)gridData);
    }

    public SideNavTextBoxComposite getSidNavTextBoxComposite() {
        return this.textBoxComp;
    }
}

