/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.preferences;

import org.eclipse.babel.editor.preferences.AbstractPrefPage;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class FormattingPrefPage
extends AbstractPrefPage {
    private Button showGeneratedBy;
    private Button convertUnicodeToEncoded;
    private Button convertUnicodeUpperCase;
    private Button alignEqualSigns;
    private Button ensureSpacesAroundEquals;
    private Button groupKeys;
    private Text groupLevelDeep;
    private Text groupLineBreaks;
    private Button groupAlignEqualSigns;
    private Button wrapLines;
    private Text wrapCharLimit;
    private Button wrapAlignEqualSigns;
    private Text wrapIndentSpaces;
    private Button wrapNewLine;
    private Button newLineTypeForce;
    private Button[] newLineTypes = new Button[3];
    private Button keepEmptyFields;
    private Button sortKeys;

    protected Control createContents(Composite parent) {
        Composite field = null;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        field = this.createFieldComposite(composite);
        this.showGeneratedBy = new Button(field, 32);
        this.showGeneratedBy.setSelection(MsgEditorPreferences.getShowSupportEnabled());
        new Label(field, 0).setText(Messages.prefs_showGeneratedBy);
        field = this.createFieldComposite(composite);
        this.convertUnicodeToEncoded = new Button(field, 32);
        this.convertUnicodeToEncoded.setSelection(MsgEditorPreferences.getUnicodeEscapeEnabled());
        this.convertUnicodeToEncoded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FormattingPrefPage.this.refreshEnabledStatuses();
            }
        });
        new Label(field, 0).setText(Messages.prefs_convertUnicode);
        field = this.createFieldComposite(composite, 20);
        this.convertUnicodeUpperCase = new Button(field, 32);
        this.convertUnicodeUpperCase.setSelection(MsgEditorPreferences.getUnicodeEscapeUppercase());
        new Label(field, 0).setText(Messages.prefs_convertUnicode_upper);
        field = this.createFieldComposite(composite);
        this.alignEqualSigns = new Button(field, 32);
        this.alignEqualSigns.setSelection(MsgEditorPreferences.getAlignEqualsEnabled());
        this.alignEqualSigns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FormattingPrefPage.this.refreshEnabledStatuses();
            }
        });
        new Label(field, 0).setText(Messages.prefs_alignEquals);
        field = this.createFieldComposite(composite);
        this.ensureSpacesAroundEquals = new Button(field, 32);
        this.ensureSpacesAroundEquals.setSelection(MsgEditorPreferences.getSpacesAroundEqualsEnabled());
        new Label(field, 0).setText(Messages.prefs_spacesAroundEquals);
        field = this.createFieldComposite(composite);
        this.groupKeys = new Button(field, 32);
        this.groupKeys.setSelection(MsgEditorPreferences.getGroupKeysEnabled());
        this.groupKeys.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FormattingPrefPage.this.refreshEnabledStatuses();
            }
        });
        new Label(field, 0).setText(Messages.prefs_groupKeys);
        field = this.createFieldComposite(composite, 20);
        new Label(field, 0).setText(Messages.prefs_levelDeep);
        this.groupLevelDeep = new Text(field, 2048);
        this.groupLevelDeep.setText(Integer.toString(MsgEditorPreferences.getGroupLevelDeepness()));
        this.groupLevelDeep.setTextLimit(2);
        this.setWidthInChars((Control)this.groupLevelDeep, 2);
        this.groupLevelDeep.addKeyListener((KeyListener)new AbstractPrefPage.IntTextValidatorKeyListener(Messages.prefs_levelDeep_error));
        field = this.createFieldComposite(composite, 20);
        new Label(field, 0).setText(Messages.prefs_linesBetween);
        this.groupLineBreaks = new Text(field, 2048);
        this.groupLineBreaks.setText(Integer.toString(MsgEditorPreferences.getGroupSeparatorBlankLineCount()));
        this.groupLineBreaks.setTextLimit(2);
        this.setWidthInChars((Control)this.groupLineBreaks, 2);
        this.groupLineBreaks.addKeyListener((KeyListener)new AbstractPrefPage.IntTextValidatorKeyListener(Messages.prefs_linesBetween_error));
        field = this.createFieldComposite(composite, 20);
        this.groupAlignEqualSigns = new Button(field, 32);
        this.groupAlignEqualSigns.setSelection(MsgEditorPreferences.getGroupAlignEqualsEnabled());
        new Label(field, 0).setText(Messages.prefs_groupAlignEquals);
        field = this.createFieldComposite(composite);
        this.wrapLines = new Button(field, 32);
        this.wrapLines.setSelection(MsgEditorPreferences.isWrapLinesEnabled());
        this.wrapLines.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FormattingPrefPage.this.refreshEnabledStatuses();
            }
        });
        new Label(field, 0).setText(Messages.prefs_wrapLines);
        field = this.createFieldComposite(composite, 20);
        new Label(field, 0).setText(Messages.prefs_wrapLinesChar);
        this.wrapCharLimit = new Text(field, 2048);
        this.wrapCharLimit.setText(Integer.toString(MsgEditorPreferences.getWrapLineLength()));
        this.wrapCharLimit.setTextLimit(4);
        this.setWidthInChars((Control)this.wrapCharLimit, 4);
        this.wrapCharLimit.addKeyListener((KeyListener)new AbstractPrefPage.IntTextValidatorKeyListener(Messages.prefs_wrapLinesChar_error));
        field = this.createFieldComposite(composite, 20);
        this.wrapAlignEqualSigns = new Button(field, 32);
        this.wrapAlignEqualSigns.setSelection(MsgEditorPreferences.isWrapAlignEqualsEnabled());
        this.wrapAlignEqualSigns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FormattingPrefPage.this.refreshEnabledStatuses();
            }
        });
        new Label(field, 0).setText(Messages.prefs_wrapAlignEquals);
        field = this.createFieldComposite(composite, 20);
        new Label(field, 0).setText(Messages.prefs_wrapIndent);
        this.wrapIndentSpaces = new Text(field, 2048);
        this.wrapIndentSpaces.setText(Integer.toString(MsgEditorPreferences.getWrapIndentLength()));
        this.wrapIndentSpaces.setTextLimit(2);
        this.setWidthInChars((Control)this.wrapIndentSpaces, 2);
        this.wrapIndentSpaces.addKeyListener((KeyListener)new AbstractPrefPage.IntTextValidatorKeyListener(Messages.prefs_wrapIndent_error));
        field = this.createFieldComposite(composite);
        this.wrapNewLine = new Button(field, 32);
        this.wrapNewLine.setSelection(MsgEditorPreferences.getNewLineNice());
        new Label(field, 0).setText(Messages.prefs_newline_nice);
        field = this.createFieldComposite(composite);
        this.newLineTypeForce = new Button(field, 32);
        this.newLineTypeForce.setSelection(MsgEditorPreferences.getForceNewLineType());
        this.newLineTypeForce.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FormattingPrefPage.this.refreshEnabledStatuses();
            }
        });
        Composite newLineRadioGroup = new Composite(field, 0);
        new Label(newLineRadioGroup, 0).setText(Messages.prefs_newline_force);
        newLineRadioGroup.setLayout((Layout)new RowLayout());
        this.newLineTypes[0] = new Button(newLineRadioGroup, 16);
        this.newLineTypes[0].setText("UNIX (\\n)");
        this.newLineTypes[1] = new Button(newLineRadioGroup, 16);
        this.newLineTypes[1].setText("Windows (\\r\\n)");
        this.newLineTypes[2] = new Button(newLineRadioGroup, 16);
        this.newLineTypes[2].setText("Mac (\\r)");
        this.newLineTypes[MsgEditorPreferences.getNewLineStyle() - 1].setSelection(true);
        field = this.createFieldComposite(composite);
        this.keepEmptyFields = new Button(field, 32);
        this.keepEmptyFields.setSelection(MsgEditorPreferences.getKeepEmptyFields());
        new Label(field, 0).setText(Messages.prefs_keepEmptyFields);
        field = this.createFieldComposite(composite);
        this.sortKeys = new Button(field, 32);
        this.sortKeys.setSelection(MsgEditorPreferences.getSortkeys());
        new Label(field, 0).setText(Messages.prefs_keysSorted);
        this.refreshEnabledStatuses();
        return composite;
    }

    public boolean performOk() {
        IEclipsePreferences prefs = MsgEditorPreferences.getEclipsePreferenceStore();
        prefs.putBoolean("showSupportEnabled", this.showGeneratedBy.getSelection());
        prefs.putBoolean("unicodeEscapeEnabled", this.convertUnicodeToEncoded.getSelection());
        prefs.putBoolean("unicodeEscapeUppercase", this.convertUnicodeUpperCase.getSelection());
        prefs.putBoolean("alignEqualsEnabled", this.alignEqualSigns.getSelection());
        prefs.putBoolean("spacesAroundEqualsEnabled", this.ensureSpacesAroundEquals.getSelection());
        prefs.putBoolean("groupKeysEnabled", this.groupKeys.getSelection());
        prefs.put("groupLevelDeep", this.groupLevelDeep.getText());
        prefs.put("groupSepBlankLineCount", this.groupLineBreaks.getText());
        prefs.putBoolean("groupAlignEqualsEnabled", this.groupAlignEqualSigns.getSelection());
        prefs.putBoolean("wrapLinesEnabled", this.wrapLines.getSelection());
        prefs.put("wrapLineLength", this.wrapCharLimit.getText());
        prefs.putBoolean("wrapAlignEqualsEnabled", this.wrapAlignEqualSigns.getSelection());
        prefs.put("wrapIndentLength", this.wrapIndentSpaces.getText());
        prefs.putBoolean("newLineNice", this.wrapNewLine.getSelection());
        prefs.putBoolean("forceNewLineType", this.newLineTypeForce.getSelection());
        int i = 0;
        while (i < this.newLineTypes.length) {
            if (this.newLineTypes[i].getSelection()) {
                prefs.putInt("newLineStyle", i + 1);
            }
            ++i;
        }
        prefs.putBoolean("keepEmptyFields", this.keepEmptyFields.getSelection());
        prefs.putBoolean("sortKeys", this.sortKeys.getSelection());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        this.refreshEnabledStatuses();
        return super.performOk();
    }

    protected void performDefaults() {
        this.showGeneratedBy.setSelection(true);
        this.convertUnicodeToEncoded.setSelection(true);
        this.convertUnicodeToEncoded.setSelection(true);
        this.alignEqualSigns.setSelection(true);
        this.alignEqualSigns.setSelection(true);
        this.groupKeys.setSelection(true);
        this.groupLevelDeep.setText(Integer.toString(1));
        this.groupLineBreaks.setText(Integer.toString(1));
        this.groupAlignEqualSigns.setSelection(true);
        this.wrapLines.setSelection(true);
        this.wrapCharLimit.setText(Integer.toString(80));
        this.wrapAlignEqualSigns.setSelection(true);
        this.wrapIndentSpaces.setText(Integer.toString(8));
        this.wrapNewLine.setSelection(false);
        this.newLineTypeForce.setSelection(false);
        this.newLineTypes[Math.min(0, 0)].setSelection(true);
        this.keepEmptyFields.setSelection(false);
        this.sortKeys.setSelection(true);
        this.refreshEnabledStatuses();
        super.performDefaults();
    }

    protected void refreshEnabledStatuses() {
        boolean isEncodingUnicode = this.convertUnicodeToEncoded.getSelection();
        boolean isGroupKeyEnabled = this.groupKeys.getSelection();
        boolean isAlignEqualsEnabled = this.alignEqualSigns.getSelection();
        boolean isWrapEnabled = this.wrapLines.getSelection();
        boolean isWrapAlignEqualsEnabled = this.wrapAlignEqualSigns.getSelection();
        boolean isNewLineStyleForced = this.newLineTypeForce.getSelection();
        this.convertUnicodeUpperCase.setEnabled(isEncodingUnicode);
        this.groupLevelDeep.setEnabled(isGroupKeyEnabled);
        this.groupLineBreaks.setEnabled(isGroupKeyEnabled);
        this.groupAlignEqualSigns.setEnabled(isGroupKeyEnabled && isAlignEqualsEnabled);
        this.wrapCharLimit.setEnabled(isWrapEnabled);
        this.wrapAlignEqualSigns.setEnabled(isWrapEnabled);
        this.wrapIndentSpaces.setEnabled(isWrapEnabled && !isWrapAlignEqualsEnabled);
        int i = 0;
        while (i < this.newLineTypes.length) {
            this.newLineTypes[i].setEnabled(isNewLineStyleForced);
            ++i;
        }
    }
}

