/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.refactoring;

import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.refactoring.RenameKeyProcessor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;

public final class RenameKeyDescriptor
extends RefactoringDescriptor {
    public static final String ID = "org.eclipse.babel.editor.refactoring.renameKey";
    private String fNewName = null;
    private KeyTreeNode fKeyNode;
    private MessagesBundleGroup fMessagesBundleGroup;
    private boolean fRenameChildKeys;

    public RenameKeyDescriptor() {
        super(ID, null, "N/A", null, 6);
    }

    public void setNewName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fNewName = name;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public void setRenameChildKeys(boolean renameChildKeys) {
        this.fRenameChildKeys = renameChildKeys;
    }

    public void setRenameChildKeys(KeyTreeNode keyNode, MessagesBundleGroup messagesBundleGroup) {
        this.fKeyNode = keyNode;
        this.fMessagesBundleGroup = messagesBundleGroup;
    }

    public boolean isRenameChildKeys() {
        return this.fRenameChildKeys;
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        String newName = this.getNewName();
        if (newName == null || newName.length() == 0) {
            status.addFatalError("The rename resource bundle key refactoring can not be performed as the new name is invalid");
            return null;
        }
        RenameKeyProcessor processor = new RenameKeyProcessor(this.fKeyNode, this.fMessagesBundleGroup);
        processor.setNewResourceName(newName);
        processor.setRenameChildKeys(this.fRenameChildKeys);
        return new RenameRefactoring((RenameProcessor)processor);
    }
}

