/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.refactoring;

import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.refactoring.RenameKeyProcessor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenameKeyWizard
extends RefactoringWizard {
    public RenameKeyWizard(KeyTreeNode resource, RenameKeyProcessor refactoring) {
        super((Refactoring)new RenameRefactoring((RenameProcessor)refactoring), 4);
        this.setDefaultPageTitle("Rename Resource Bundle Key");
        this.setWindowTitle("Rename Resource Bundle Key");
    }

    protected void addUserInputPages() {
        RenameKeyProcessor processor = (RenameKeyProcessor)((Object)this.getRefactoring().getAdapter(RenameKeyProcessor.class));
        this.addPage((IWizardPage)new RenameResourceRefactoringConfigurationPage(processor));
    }

    private static class RenameResourceRefactoringConfigurationPage
    extends UserInputWizardPage {
        private final RenameKeyProcessor fRefactoringProcessor;
        private Text fNameField;

        public RenameResourceRefactoringConfigurationPage(RenameKeyProcessor processor) {
            super("RenameResourceRefactoringInputPage");
            this.fRefactoringProcessor = processor;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText("New name:");
            label.setLayoutData((Object)new GridData());
            this.fNameField = new Text(composite, 2048);
            this.fNameField.setText(this.fRefactoringProcessor.getNewResourceName());
            this.fNameField.setFont(composite.getFont());
            this.fNameField.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.validatePage();
                }
            });
            final Button includeChildKeysCheckbox = new Button(composite, 32);
            if (this.fRefactoringProcessor.getNewKeyTreeNode().isUsedAsKey()) {
                if (this.fRefactoringProcessor.getNewKeyTreeNode().getChildren().length == 0) {
                    includeChildKeysCheckbox.setSelection(false);
                    includeChildKeysCheckbox.setEnabled(false);
                } else {
                    includeChildKeysCheckbox.setSelection(this.fRefactoringProcessor.getRenameChildKeys());
                    includeChildKeysCheckbox.setEnabled(true);
                }
            } else {
                includeChildKeysCheckbox.setSelection(true);
                includeChildKeysCheckbox.setEnabled(false);
            }
            includeChildKeysCheckbox.setText("Also rename child keys (other keys with this key as a prefix)");
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            includeChildKeysCheckbox.setLayoutData((Object)gd);
            includeChildKeysCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fRefactoringProcessor.setRenameChildKeys(includeChildKeysCheckbox.getSelection());
                }
            });
            this.fNameField.selectAll();
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.fNameField.setFocus();
            }
            super.setVisible(visible);
        }

        protected final void validatePage() {
            String text = this.fNameField.getText();
            RefactoringStatus status = this.fRefactoringProcessor.validateNewElementName(text);
            this.setPageComplete(status);
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
        }

        private void initializeRefactoring() {
            this.fRefactoringProcessor.setNewResourceName(this.fNameField.getText());
        }
    }
}

