/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.resource;

import java.util.Locale;
import org.eclipse.babel.core.configuration.DirtyHack;
import org.eclipse.babel.core.message.resource.internal.AbstractPropertiesResource;
import org.eclipse.babel.core.message.resource.ser.PropertiesDeserializer;
import org.eclipse.babel.core.message.resource.ser.PropertiesSerializer;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;

public class EclipsePropertiesEditorResource
extends AbstractPropertiesResource {
    private TextEditor textEditor;
    private String _resourceLocationLabel;

    public EclipsePropertiesEditorResource(Locale locale, PropertiesSerializer serializer, PropertiesDeserializer deserializer, TextEditor textEditor) {
        super(locale, serializer, deserializer);
        this.textEditor = textEditor;
    }

    @Override
    public String getText() {
        return this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).get();
    }

    @Override
    public void setText(String content) {
        if (DirtyHack.isEditorModificationEnabled()) {
            this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).set(content);
        }
    }

    @Override
    public Object getSource() {
        return this.textEditor;
    }

    public IResource getResource() {
        IEditorInput input = this.textEditor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    @Override
    public String getResourceLocationLabel() {
        if (this._resourceLocationLabel != null) {
            return this._resourceLocationLabel;
        }
        IResource resource = this.getResource();
        if (resource != null) {
            return resource.getFullPath().toString();
        }
        return null;
    }

    public void setResourceLocationLabel(String resourceLocationLabel) {
        this._resourceLocationLabel = resourceLocationLabel;
    }

    @Override
    public void dispose() {
    }
}

