/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.resource.validator;

import org.eclipse.babel.core.message.checks.internal.DuplicateValueCheck;
import org.eclipse.babel.core.message.checks.internal.MissingValueCheck;
import org.eclipse.babel.core.message.internal.MessagesBundle;
import org.eclipse.babel.core.util.BabelUtils;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.editor.resource.validator.IValidationMarkerStrategy;
import org.eclipse.babel.editor.resource.validator.ValidationFailureEvent;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class FileMarkerStrategy
implements IValidationMarkerStrategy {
    @Override
    public void markFailed(ValidationFailureEvent event) {
        if (event.getCheck() instanceof MissingValueCheck) {
            MessagesBundle bundle = (MessagesBundle)event.getBundleGroup().getMessagesBundle(event.getLocale());
            this.addMarker((IResource)bundle.getResource().getSource(), event.getKey(), "Key \"" + event.getKey() + "\" is missing a value.", FileMarkerStrategy.getSeverity(MsgEditorPreferences.getReportMissingValuesLevel()));
        } else if (event.getCheck() instanceof DuplicateValueCheck) {
            String duplicates = BabelUtils.join(((DuplicateValueCheck)event.getCheck()).getDuplicateKeys(), ", ");
            MessagesBundle bundle = (MessagesBundle)event.getBundleGroup().getMessagesBundle(event.getLocale());
            this.addMarker((IResource)bundle.getResource().getSource(), event.getKey(), "Key \"" + event.getKey() + "\" duplicates " + duplicates, FileMarkerStrategy.getSeverity(MsgEditorPreferences.getReportDuplicateValuesLevel()));
        }
    }

    private void addMarker(IResource resource, String key, String message, int severity) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.babel.editor.nlsproblem");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            marker.setAttribute("location", (Object)key);
        }
        catch (CoreException e) {
            throw new RuntimeException("Cannot add marker.", e);
        }
    }

    private static int getSeverity(int msgValidationLevel) {
        switch (msgValidationLevel) {
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 0;
    }
}

