/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.tree.actions;

import java.text.MessageFormat;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.tree.actions.AbstractTreeAction;
import org.eclipse.babel.messages.Messages;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class DeleteKeyAction
extends AbstractTreeAction {
    public DeleteKeyAction(AbstractMessagesEditor editor, TreeViewer treeViewer) {
        super(editor, treeViewer);
        this.setText(Messages.key_delete);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setToolTipText(Messages.key_delete);
    }

    public void run() {
        KeyTreeNode node = this.getNodeSelection();
        String key = node.getMessageKey();
        String msgHead = null;
        String msgBody = null;
        if (this.getContentProvider().hasChildren((Object)node)) {
            msgHead = Messages.dialog_delete_head_multiple;
            msgBody = MessageFormat.format(Messages.dialog_delete_body_multiple, key);
        } else {
            msgHead = Messages.dialog_delete_head_single;
            msgBody = MessageFormat.format(Messages.dialog_delete_body_single, key);
        }
        MessageBox msgBox = new MessageBox(this.getShell(), 292);
        msgBox.setMessage(msgBody);
        msgBox.setText(msgHead);
        if (msgBox.open() == 32) {
            MessagesBundleGroup messagesBundleGroup = this.getBundleGroup();
            KeyTreeNode[] nodesToDelete = this.getBranchNodes(node);
            int i = 0;
            while (i < nodesToDelete.length) {
                KeyTreeNode nodeToDelete = nodesToDelete[i];
                messagesBundleGroup.removeMessages(nodeToDelete.getMessageKey());
                ++i;
            }
        }
    }
}

