/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.tree.actions;

import org.eclipse.babel.core.message.manager.RBManager;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.tree.actions.AbstractTreeAction;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.babel.messages.Messages;
import org.eclipse.jface.viewers.TreeViewer;

public class RefactorKeyAction
extends AbstractTreeAction {
    public RefactorKeyAction(AbstractMessagesEditor editor, TreeViewer treeViewer) {
        super(editor, treeViewer);
        this.setText(String.valueOf(Messages.key_rename) + " ...");
        this.setImageDescriptor(UIUtils.getImageDescriptor("refactoring.png"));
        this.setToolTipText("Rename the selected key");
    }

    public void run() {
        KeyTreeNode node = this.getNodeSelection();
        String key = node.getMessageKey();
        String bundleId = node.getMessagesBundleGroup().getResourceBundleId();
        String projectName = node.getMessagesBundleGroup().getProjectName();
        RBManager.getRefactorService().openRefactorDialog(projectName, bundleId, key, null);
        this.editor.updateBundleGroup();
    }
}

