/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageIcon
extends CompositeImageDescriptor {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private Image baseImage;
    private Image overlayImage;
    private int location;
    private Point imgSize;

    public OverlayImageIcon(Image baseImage, Image overlayImage, int location) {
        this.baseImage = baseImage;
        this.overlayImage = overlayImage;
        this.location = location;
        this.imgSize = new Point(baseImage.getImageData().width, baseImage.getImageData().height);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.baseImage.getImageData(), 0, 0);
        ImageData imageData = this.overlayImage.getImageData();
        switch (this.location) {
            case 0: {
                this.drawImage(imageData, 0, 0);
                break;
            }
            case 1: {
                this.drawImage(imageData, this.imgSize.x - imageData.width, 0);
                break;
            }
            case 2: {
                this.drawImage(imageData, 0, this.imgSize.y - imageData.height);
                break;
            }
            case 3: {
                this.drawImage(imageData, this.imgSize.x - imageData.width, this.imgSize.y - imageData.height);
            }
        }
    }

    protected Point getSize() {
        return this.imgSize;
    }
}

