/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.wizards.internal;

import com.jaspersoft.translation.wizard.HelpWizardPage;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.babel.editor.widgets.LocaleSelector;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class ResourceBundleNewWizardPage
extends HelpWizardPage {
    public static final String DEFAULT_LOCALE = "[" + Messages.editor_default + "]";
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private Button addButton;
    private Button removeButton;
    protected List bundleLocalesList;
    private LocaleSelector localeSelector;
    private String defaultPath = "";
    private String defaultRBName = "ApplicationResources";

    public ResourceBundleNewWizardPage(ISelection selection, String defaultPath, String defaultRBName) {
        super("wizardPage");
        this.setTitle(Messages.editor_wiz_title);
        this.setDescription(Messages.editor_wiz_desc);
        this.selection = selection;
        if (!defaultPath.isEmpty()) {
            this.defaultPath = defaultPath;
        }
        if (!defaultRBName.isEmpty()) {
            this.defaultRBName = defaultRBName;
        }
    }

    public ResourceBundleNewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.editor_wiz_title);
        this.setDescription(Messages.editor_wiz_desc);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 20;
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        this.createTopComposite(container);
        this.createBottomComposite(container);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    protected void createBottomComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        this.createBottomAvailableLocalesComposite(container);
        this.createBottomButtonsComposite(container);
        this.createBottomSelectedLocalesComposite(container);
    }

    private void createBottomSelectedLocalesComposite(Composite parent) {
        Group selectedGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout = new GridLayout();
        layout.numColumns = 1;
        selectedGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        selectedGroup.setLayoutData((Object)gd);
        selectedGroup.setText(Messages.editor_wiz_selected);
        this.bundleLocalesList = new List((Composite)selectedGroup, 2058);
        gd = new GridData(1808);
        this.bundleLocalesList.setLayoutData((Object)gd);
        this.bundleLocalesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResourceBundleNewWizardPage.this.removeButton.setEnabled(ResourceBundleNewWizardPage.this.bundleLocalesList.getSelectionIndices().length != 0);
                ResourceBundleNewWizardPage.this.setAddButtonState();
            }
        });
        this.bundleLocalesList.add(DEFAULT_LOCALE);
    }

    private void createBottomButtonsComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        this.addButton = new Button(container, 0);
        gd = new GridData(768);
        this.addButton.setLayoutData((Object)gd);
        this.addButton.setText(Messages.editor_wiz_add);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResourceBundleNewWizardPage.this.bundleLocalesList.add(ResourceBundleNewWizardPage.this.getSelectedLocaleAsString());
                ResourceBundleNewWizardPage.this.setAddButtonState();
                ResourceBundleNewWizardPage.this.dialogChanged();
            }
        });
        this.removeButton = new Button(container, 0);
        gd = new GridData(768);
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.setText(Messages.editor_wiz_remove);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResourceBundleNewWizardPage.this.bundleLocalesList.remove(ResourceBundleNewWizardPage.this.bundleLocalesList.getSelectionIndices());
                ResourceBundleNewWizardPage.this.removeButton.setEnabled(false);
                ResourceBundleNewWizardPage.this.setAddButtonState();
                ResourceBundleNewWizardPage.this.dialogChanged();
            }
        });
    }

    private void createBottomAvailableLocalesComposite(Composite parent) {
        this.localeSelector = new LocaleSelector(parent);
        this.localeSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceBundleNewWizardPage.this.setAddButtonState();
            }
        });
    }

    protected void createTopComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(Messages.editor_wiz_folder);
        this.containerText = new Text(container, 2052);
        gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceBundleNewWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.editor_wiz_browse);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceBundleNewWizardPage.this.handleBrowse();
            }
        });
        this.createBundleNameArea(container);
    }

    protected void createBundleNameArea(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.editor_wiz_bundleName);
        this.fileText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceBundleNewWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("[locale].properties");
    }

    private void initialize() {
        if (!this.defaultPath.isEmpty()) {
            this.containerText.setText(this.defaultPath);
        } else if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
                if (resource.getType() == 1) {
                    resource = resource.getParent();
                }
                this.containerText.setText(resource.getFullPath().toPortableString());
            } else if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toPortableString());
            }
        }
        if (this.fileText != null) {
            this.fileText.setText(this.defaultRBName);
        }
    }

    protected void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.editor_wiz_selectFolder);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toOSString());
        }
    }

    protected void dialogChanged() {
        String container = this.getContainerName();
        String baseName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus(Messages.editor_wiz_error_container, 3);
            return;
        }
        if (baseName.length() == 0) {
            this.updateStatus(Messages.editor_wiz_error_bundleName, 3);
            return;
        }
        int dotLoc = baseName.lastIndexOf(46);
        if (dotLoc != -1) {
            this.updateStatus(Messages.editor_wiz_error_extension, 3);
            return;
        }
        if (this.bundleLocalesList.getItemCount() <= 0) {
            this.updateStatus(Messages.editor_wiz_error_noLocale, 3);
            return;
        }
        Path pathContainer = new Path(container);
        if (!pathContainer.isValidPath(container)) {
            this.updateStatus(Messages.editor_wiz_error_invalidpath, 3);
            return;
        }
        if (pathContainer.segmentCount() < 1) {
            this.updateStatus(Messages.editor_wiz_error_invalidpath, 3);
            return;
        }
        if (!this.resourceExist(pathContainer.segment(0))) {
            String errormessage = Messages.editor_wiz_error_projectnotexist;
            errormessage = String.format(errormessage, pathContainer.segment(0));
            this.updateStatus(errormessage, 3);
            return;
        }
        String[] locales = this.getLocaleStrings();
        int i = 0;
        while (i < locales.length) {
            String fileName = baseName;
            fileName = locales[i].equals(DEFAULT_LOCALE) ? String.valueOf(fileName) + ".properties" : String.valueOf(fileName) + "_" + locales[i] + ".properties";
            IPath resourcePath = pathContainer.append((IPath)new Path(fileName));
            if (this.resourceExist(resourcePath.toString())) {
                String errormessage = Messages.ResourceBundleNewWizardPage_errorResourceExisting;
                errormessage = MessageFormat.format(errormessage, fileName);
                this.updateStatus(errormessage, 3);
                return;
            }
            ++i;
        }
        this.updateStatus(null, 0);
    }

    protected void updateStatus(String message, int messageType) {
        this.setMessage(message, messageType);
        this.setPageComplete(messageType != 3);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    void setAddButtonState() {
        this.addButton.setEnabled(this.bundleLocalesList.indexOf(this.getSelectedLocaleAsString()) == -1);
    }

    protected String[] getLocaleStrings() {
        return this.bundleLocalesList.getItems();
    }

    protected String getSelectedLocaleAsString() {
        Locale selectedLocale = this.localeSelector.getSelectedLocale();
        if (selectedLocale != null) {
            return selectedLocale.toString();
        }
        return DEFAULT_LOCALE;
    }

    protected boolean resourceExist(String resourceName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path containerNamePath = null;
        containerNamePath = resourceName.startsWith("/") ? new Path(resourceName) : new Path("/" + resourceName);
        IResource resource = root.findMember((IPath)containerNamePath);
        if (resource == null) {
            return false;
        }
        return resource.exists();
    }

    public void setDefaultRBName(String name) {
        this.defaultRBName = name;
    }

    public void setDefaultPath(String path) {
        this.defaultPath = path;
    }

    @Override
    protected String getContextName() {
        return null;
    }
}

