/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.parser;

import org.eclipse.pde.nls.internal.ui.parser.IScannerSource;

public class LexicalErrorException
extends RuntimeException {
    private int lineNumber;
    private int columnNumber;

    public LexicalErrorException(IScannerSource source) {
        this(source.getCurrentLineNumber(), source.getCurrentColumnNumber(), null);
    }

    public LexicalErrorException(IScannerSource source, String message) {
        this(source.getCurrentLineNumber(), source.getCurrentColumnNumber(), message);
    }

    public LexicalErrorException(int line, int column, String message) {
        super("Lexical error (" + line + ", " + column + (message == null ? ")" : "): " + message));
        this.lineNumber = line;
        this.columnNumber = column;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public static LexicalErrorException unexpectedCharacter(IScannerSource source, int c) {
        return new LexicalErrorException(source, "Unexpected character: '" + (char)c + "' (0x" + LexicalErrorException.hexDigit(c >> 4 & 0xF) + LexicalErrorException.hexDigit(c & 0xF) + ")");
    }

    private static char hexDigit(int digit) {
        return "0123456789abcdef".charAt(digit);
    }
}

