/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.pde.nls.internal.ui.parser.CharArraySource;
import org.eclipse.pde.nls.internal.ui.parser.IScannerSource;
import org.eclipse.pde.nls.internal.ui.parser.LexicalErrorException;

public class RawBundle {
    private ArrayList<RawLine> lines = new ArrayList();

    public EntryLine getEntryLine(String key) {
        for (RawLine line : this.lines) {
            if (!(line instanceof EntryLine)) continue;
            EntryLine entryLine = (EntryLine)line;
            if (!entryLine.key.equals(key)) continue;
            return entryLine;
        }
        return null;
    }

    public void put(String key, String value) {
        int size = this.lines.size();
        int pos = -1;
        int i = 0;
        while (i < size) {
            RawLine line = this.lines.get(i);
            if (line instanceof EntryLine) {
                EntryLine entryLine = (EntryLine)line;
                int compare = key.compareToIgnoreCase(entryLine.key);
                if (compare < 0) {
                    if (pos == -1) {
                        pos = i;
                    }
                } else if (compare <= 0) {
                    if (key.equals(entryLine.key)) {
                        entryLine.rawData = String.valueOf(key) + "=" + this.escape(value) + "\r\n";
                        return;
                    }
                    pos = i;
                }
            }
            ++i;
        }
        if (pos == -1) {
            pos = this.lines.size();
        }
        this.lines.add(pos, new EntryLine(key, String.valueOf(key) + "=" + this.escape(value) + "\r\n"));
    }

    private String escape(String str) {
        StringBuilder builder = new StringBuilder();
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0) {
                        builder.append("\\ ");
                        break;
                    }
                    builder.append(c);
                    break;
                }
                case '\t': {
                    builder.append("\\t");
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    builder.append('\\').append(c);
                    break;
                }
                default: {
                    if ('\u001f' <= c && c <= '\u00ff') {
                        builder.append(c);
                        break;
                    }
                    builder.append("\\u");
                    builder.append(RawBundle.hexDigit(c >> 12 & 0xF));
                    builder.append(RawBundle.hexDigit(c >> 8 & 0xF));
                    builder.append(RawBundle.hexDigit(c >> 4 & 0xF));
                    builder.append(RawBundle.hexDigit(c & 0xF));
                }
            }
            ++i;
        }
        return builder.toString();
    }

    private static char hexDigit(int digit) {
        return "0123456789ABCDEF".charAt(digit);
    }

    public void writeTo(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "ISO-8859-1");
        this.writeTo(writer);
    }

    public void writeTo(Writer writer) throws IOException {
        for (RawLine line : this.lines) {
            writer.write(line.rawData);
        }
    }

    public static RawBundle createFrom(InputStream in) throws IOException {
        CharArraySource source = CharArraySource.createFrom(new InputStreamReader(in, "ISO-8859-1"));
        return RawBundle.createFrom(source);
    }

    public static RawBundle createFrom(Reader reader) throws IOException {
        CharArraySource source = CharArraySource.createFrom(reader);
        return RawBundle.createFrom(source);
    }

    public static RawBundle createFrom(IScannerSource source) throws IOException {
        RawBundle rawBundle = new RawBundle();
        StringBuilder builder = new StringBuilder();
        while (source.hasMoreChars()) {
            int begin = source.getPosition();
            RawBundle.skipAllOf(" \t\f", source);
            if (source.lookahead() == 35 || source.lookahead() == 33) {
                RawBundle.skipToOneOf("\r\n", false, source);
                RawBundle.consumeLineSeparator(source);
                int end = source.getPosition();
                String line = source.toString(begin, end);
                rawBundle.lines.add(new CommentLine(line));
                continue;
            }
            if (RawBundle.isAtLineEnd(source)) {
                RawBundle.consumeLineSeparator(source);
                int end = source.getPosition();
                String line = source.toString(begin, end);
                rawBundle.lines.add(new EmptyLine(line));
                continue;
            }
            builder.setLength(0);
            block9: while (source.hasMoreChars()) {
                char c = (char)source.readChar();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '=': {
                        break block9;
                    }
                    case '\\': {
                        source.unreadChar();
                        builder.append(RawBundle.readEscapedChar(source));
                        break;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            String key = builder.toString();
            int end = 0;
            block10: while (source.hasMoreChars()) {
                char c = (char)source.readChar();
                switch (c) {
                    case '\n': 
                    case '\r': {
                        RawBundle.consumeLineSeparator(source);
                        end = source.getPosition();
                        break block10;
                    }
                    case '\\': {
                        if (RawBundle.isAtLineEnd(source)) {
                            RawBundle.consumeLineSeparator(source);
                        } else {
                            source.unreadChar();
                            RawBundle.readEscapedChar(source);
                        }
                    }
                    default: {
                        continue block10;
                    }
                }
            }
            if (end == 0) {
                end = source.getPosition();
            }
            String lineData = source.toString(begin, end);
            EntryLine entryLine = new EntryLine(key, lineData);
            rawBundle.lines.add(entryLine);
        }
        return rawBundle;
    }

    private static char readEscapedChar(IScannerSource source) {
        source.readChar(92);
        char c = (char)source.readChar();
        switch (c) {
            case ' ': 
            case '!': 
            case '#': 
            case ':': 
            case '=': 
            case '\\': {
                return c;
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'u': {
                int d1 = Character.digit(source.readChar(), 16);
                int d2 = Character.digit(source.readChar(), 16);
                int d3 = Character.digit(source.readChar(), 16);
                int d4 = Character.digit(source.readChar(), 16);
                if (d1 == -1 || d2 == -1 || d3 == -1 || d4 == -1) {
                    throw new LexicalErrorException(source, "Illegal escape sequence");
                }
                return (char)(d1 << 12 | d2 << 8 | d3 << 4 | d4);
            }
        }
        throw new LexicalErrorException(source, "Unknown escape sequence");
    }

    private static boolean isAtLineEnd(IScannerSource source) {
        return source.lookahead() == 13 || source.lookahead() == 10;
    }

    private static void consumeLineSeparator(IScannerSource source) {
        if (source.lookahead() == 10) {
            source.readChar();
            source.pushLineSeparator();
        } else if (source.lookahead() == 13) {
            source.readChar();
            if (source.lookahead() == 10) {
                source.readChar();
            }
            source.pushLineSeparator();
        }
    }

    private static void skipToOneOf(String delimiters, boolean readDelimiter, IScannerSource source) {
        while (source.hasMoreChars()) {
            int c = source.readChar();
            if (delimiters.indexOf(c) != -1) {
                if (readDelimiter) break;
                source.unreadChar();
                break;
            }
            if (c != 13) continue;
            source.readChar(10);
            source.pushLineSeparator();
        }
    }

    private static void skipAllOf(String string, IScannerSource source) {
        while (source.hasMoreChars() && string.indexOf(source.lookahead()) != -1) {
            source.readChar();
        }
    }

    public static class CommentLine
    extends RawLine {
        public CommentLine(String line) {
            super(line);
        }
    }

    public static class EmptyLine
    extends RawLine {
        public EmptyLine(String line) {
            super(line);
        }
    }

    public static class EntryLine
    extends RawLine {
        String key;

        public EntryLine(String key, String lineData) {
            super(lineData);
            this.key = key;
        }
    }

    public static abstract class RawLine {
        String rawData;

        public RawLine(String rawData) {
            this.rawData = rawData;
        }

        public String getRawData() {
            return this.rawData;
        }
    }
}

