/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.history;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class RevisionAnnotationController {
    private ISelectionProvider fRulerSelectionProvider;
    private ISelectionProvider fHistoryListSelectionProvider;
    private ISelectionChangedListener rulerListener = event -> {
        ISelection selection = event.getSelection();
        Revision selected = null;
        if (selection instanceof IStructuredSelection) {
            selected = (Revision)((IStructuredSelection)selection).getFirstElement();
        }
        if (selected == null) {
            return;
        }
        this.revisionSelected(selected);
    };
    private ISelectionChangedListener historyListListener = event -> {
        Object first;
        IStructuredSelection ss;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (first = ss.getFirstElement()) != null) {
            this.historyEntrySelected(first);
        }
    };

    public static AbstractDecoratedTextEditor openEditor(IWorkbenchPage page, IFile file) throws PartInitException {
        AbstractDecoratedTextEditor te;
        if (file == null) {
            return null;
        }
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart[] openEditors = RevisionAnnotationController.findOpenEditorsForFile(page, input);
        if (openEditors.length > 0 && (te = RevisionAnnotationController.findTextEditor(page, openEditors, (IEditorInput)input)) != null) {
            return te;
        }
        try {
            AbstractDecoratedTextEditor te2;
            IEditorPart part;
            IEditorDescriptor descrptr = IDE.getEditorDescriptor((IFile)file, (boolean)true, (boolean)true);
            if (descrptr.isInternal() && openEditors.length == 0) {
                part = page.openEditor((IEditorInput)input, IDE.getEditorDescriptor((IFile)file, (boolean)true, (boolean)true).getId(), true, 1);
                te2 = RevisionAnnotationController.findTextEditorPart(page, part, (IEditorInput)input);
                if (te2 != null) {
                    return te2;
                }
                page.closeEditor(part, false);
            }
            if ((te2 = RevisionAnnotationController.findTextEditorPart(page, part = page.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor", true, 3), (IEditorInput)input)) != null) {
                return te2;
            }
        }
        catch (PartInitException partInitException) {}
        return null;
    }

    public static AbstractDecoratedTextEditor openEditor(IWorkbenchPage page, Object fileRevision, IStorage storage) throws PartInitException {
        String id = RevisionAnnotationController.getEditorId(storage);
        ITextEditor editor = RevisionAnnotationController.getEditor(id, fileRevision, storage);
        if (editor instanceof AbstractDecoratedTextEditor) {
            return (AbstractDecoratedTextEditor)editor;
        }
        return null;
    }

    private static ITextEditor getEditor(String id, Object fileRevision, IStorage storage) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)new FileRevisionEditorInput(fileRevision, storage), id);
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        page.closeEditor(part, false);
        part = page.openEditor((IEditorInput)new FileRevisionEditorInput(fileRevision, storage), "org.eclipse.ui.DefaultTextEditor");
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        throw new PartInitException(TeamUIMessages.RevisionAnnotationController_0);
    }

    private static String getEditorId(IStorage storage) {
        String id;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(storage.getName());
        if (descriptor == null || !descriptor.isInternal()) {
            id = "org.eclipse.ui.DefaultTextEditor";
        } else {
            try {
                id = Utils.isTextEditor(descriptor) ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
            }
            catch (CoreException coreException) {
                id = "org.eclipse.ui.DefaultTextEditor";
            }
        }
        return id;
    }

    private static AbstractDecoratedTextEditor findOpenTextEditorForFile(IWorkbenchPage page, IFile file) {
        if (file == null) {
            return null;
        }
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart[] editors = RevisionAnnotationController.findOpenEditorsForFile(page, input);
        return RevisionAnnotationController.findTextEditor(page, editors, (IEditorInput)input);
    }

    private static AbstractDecoratedTextEditor findTextEditor(IWorkbenchPage page, IEditorPart[] editors, IEditorInput input) {
        IEditorPart[] iEditorPartArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor = iEditorPartArray[n2];
            AbstractDecoratedTextEditor te = RevisionAnnotationController.findTextEditorPart(page, editor, input);
            if (te != null) {
                return te;
            }
            ++n2;
        }
        return null;
    }

    private static AbstractDecoratedTextEditor findTextEditorPart(IWorkbenchPage page, IEditorPart editor, IEditorInput input) {
        if (editor instanceof AbstractDecoratedTextEditor) {
            return (AbstractDecoratedTextEditor)editor;
        }
        if (editor instanceof MultiPageEditorPart) {
            IEditorPart[] parts;
            MultiPageEditorPart mpep = (MultiPageEditorPart)editor;
            IEditorPart[] iEditorPartArray = parts = mpep.findEditors(input);
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editorPart = iEditorPartArray[n2];
                if (editorPart instanceof AbstractDecoratedTextEditor) {
                    page.activate((IWorkbenchPart)mpep);
                    mpep.setActiveEditor(editorPart);
                    return (AbstractDecoratedTextEditor)editorPart;
                }
                ++n2;
            }
        }
        return null;
    }

    private static IEditorPart[] findOpenEditorsForFile(IWorkbenchPage page, FileEditorInput input) {
        IEditorReference[] references = page.findEditors((IEditorInput)input, null, 1);
        ArrayList<IEditorPart> editors = new ArrayList<IEditorPart>();
        IEditorReference[] iEditorReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            IEditorPart editor = reference.getEditor(false);
            editors.add(editor);
            ++n2;
        }
        return editors.toArray(new IEditorPart[editors.size()]);
    }

    private static AbstractDecoratedTextEditor findOpenTextEditorFor(IWorkbenchPage page, Object object) {
        IEditorReference[] references;
        if (object == null) {
            return null;
        }
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return RevisionAnnotationController.findOpenTextEditorForFile(page, file);
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorReference[] iEditorReferenceArray = references = window.getActivePage().getEditorReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            try {
                IEditorPart editor;
                if (object.equals(reference.getEditorInput()) && (editor = reference.getEditor(false)) instanceof AbstractDecoratedTextEditor) {
                    return (AbstractDecoratedTextEditor)editor;
                }
            }
            catch (PartInitException partInitException) {}
            ++n2;
        }
        return null;
    }

    private static IRevisionRulerColumnExtension findEditorRevisonRulerColumn(IWorkbenchPage page, Object object) {
        AbstractDecoratedTextEditor editor = RevisionAnnotationController.findOpenTextEditorFor(page, object);
        if (editor == null) {
            return null;
        }
        IRevisionRulerColumn column = (IRevisionRulerColumn)editor.getAdapter(IRevisionRulerColumn.class);
        if (column instanceof IRevisionRulerColumnExtension) {
            if (column.getControl() != null && column.getControl().isDisposed()) {
                return null;
            }
            return (IRevisionRulerColumnExtension)column;
        }
        return null;
    }

    private RevisionAnnotationController(IRevisionRulerColumnExtension revisionRuler, ISelectionProvider historyList) {
        this.fHistoryListSelectionProvider = historyList;
        if (revisionRuler == null) {
            this.fRulerSelectionProvider = null;
            return;
        }
        this.fRulerSelectionProvider = revisionRuler.getRevisionSelectionProvider();
        this.fRulerSelectionProvider.addSelectionChangedListener(this.rulerListener);
        this.fHistoryListSelectionProvider.addSelectionChangedListener(this.historyListListener);
        ((IRevisionRulerColumn)revisionRuler).getControl().addDisposeListener(e -> this.dispose());
    }

    public RevisionAnnotationController(IWorkbenchPage page, IFile file, ISelectionProvider historyList) {
        this(RevisionAnnotationController.findEditorRevisonRulerColumn(page, file), historyList);
    }

    public RevisionAnnotationController(IWorkbenchPage page, IStorageEditorInput editorInput, ISelectionProvider historyList) {
        this(RevisionAnnotationController.findEditorRevisonRulerColumn(page, editorInput), historyList);
    }

    public void dispose() {
        if (this.fRulerSelectionProvider != null) {
            this.fRulerSelectionProvider.removeSelectionChangedListener(this.rulerListener);
            this.fHistoryListSelectionProvider.removeSelectionChangedListener(this.historyListListener);
            this.rulerListener = null;
            this.fRulerSelectionProvider = null;
            this.historyListListener = null;
            this.fHistoryListSelectionProvider = null;
        }
    }

    protected void revisionSelected(Revision selected) {
        Object entry = this.getHistoryEntry(selected);
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection(entry);
            if (this.fHistoryListSelectionProvider instanceof Viewer) {
                Viewer v = (Viewer)this.fHistoryListSelectionProvider;
                v.setSelection((ISelection)selection, true);
            } else if (this.fHistoryListSelectionProvider != null) {
                this.fHistoryListSelectionProvider.setSelection((ISelection)selection);
            }
        }
    }

    protected abstract Object getHistoryEntry(Revision var1);

    void historyEntrySelected(Object historyEntry) {
        String id = this.getRevisionId(historyEntry);
        if (id != null && this.fRulerSelectionProvider != null) {
            this.fRulerSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)id));
        }
    }

    protected String getRevisionId(Object historyEntry) {
        IFileRevision revision = (IFileRevision)Adapters.adapt((Object)historyEntry, IFileRevision.class);
        if (revision != null) {
            return revision.getContentIdentifier();
        }
        IResourceVariant variant = (IResourceVariant)Adapters.adapt((Object)historyEntry, IResourceVariant.class);
        if (variant != null) {
            return variant.getContentIdentifier();
        }
        return null;
    }
}

