/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.history.GenericHistoryView;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.dialogs.DifferencesDialog;
import org.tigris.subversion.subclipse.ui.history.SVNHistoryPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ShowDifferencesAsUnifiedDiffAction
extends WorkbenchWindowAction {
    private boolean usePegRevision;
    private SVNRevision pegRevision1;
    private SVNRevision pegRevision2;

    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IHistoryPage historyPage;
        this.pegRevision1 = null;
        this.pegRevision2 = null;
        String fromRevision = null;
        String toRevision = null;
        ISVNRemoteResource[] selectedResources = this.getSelectedRemoteResources();
        SVNUrl fromUrl = null;
        SVNUrl toUrl = null;
        if (selectedResources == null || selectedResources.length == 0) {
            Object[] selectedObjects = this.selection.toArray();
            if (selectedObjects[0] instanceof ILogEntry) {
                selectedResources = new ISVNResource[2];
                selectedResources[0] = ((ILogEntry)selectedObjects[0]).getResource();
                fromRevision = ((ILogEntry)selectedObjects[0]).getRevision().toString();
                ILogEntry logEntry1 = (ILogEntry)selectedObjects[0];
                IResource resource1 = logEntry1.getResource().getResource();
                if (resource1 != null) {
                    try {
                        ISVNRemoteResource baseResource = SVNWorkspaceRoot.getBaseResourceFor((IResource)resource1);
                        if (baseResource != null) {
                            this.pegRevision1 = baseResource.getLastChangedRevision();
                        }
                    }
                    catch (Exception exception) {}
                }
                Object remoteResource = logEntry1.getResource().getResource() instanceof IContainer ? new RemoteFolder(logEntry1.getResource().getRepository(), logEntry1.getResource().getUrl(), (SVNRevision)logEntry1.getRevision()) : new RemoteFile(logEntry1.getResource().getRepository(), logEntry1.getResource().getUrl(), (SVNRevision)logEntry1.getRevision());
                fromUrl = remoteResource.getUrl();
                if (selectedObjects.length > 1) {
                    selectedResources[1] = ((ILogEntry)selectedObjects[1]).getResource();
                    toRevision = ((ILogEntry)selectedObjects[1]).getRevision().toString();
                    ILogEntry logEntry2 = (ILogEntry)selectedObjects[1];
                    IResource resource2 = logEntry2.getResource().getResource();
                    if (resource2 != null) {
                        try {
                            ISVNRemoteResource baseResource = SVNWorkspaceRoot.getBaseResourceFor((IResource)resource2);
                            if (baseResource != null) {
                                this.pegRevision2 = baseResource.getLastChangedRevision();
                            }
                        }
                        catch (Exception exception) {}
                    }
                    remoteResource = logEntry2.getResource().getResource() instanceof IContainer ? new RemoteFolder(logEntry2.getResource().getRepository(), logEntry2.getResource().getUrl(), (SVNRevision)logEntry2.getRevision()) : new RemoteFile(logEntry2.getResource().getRepository(), logEntry2.getResource().getUrl(), (SVNRevision)logEntry2.getRevision());
                    toUrl = remoteResource.getUrl();
                } else {
                    int from = Integer.parseInt(fromRevision);
                    toRevision = Integer.toString(--from);
                    toUrl = remoteResource.getUrl();
                }
            }
        } else {
            if (selectedResources[0] instanceof ISVNRemoteResource) {
                fromRevision = selectedResources[0].getRevision().toString();
            }
            if (selectedResources.length > 1 && selectedResources[1] instanceof ISVNRemoteResource) {
                toRevision = selectedResources[1].getRevision().toString();
            }
        }
        if (this.pegRevision1 == null) {
            this.pegRevision1 = SVNRevision.HEAD;
        }
        if (this.pegRevision2 == null) {
            this.pegRevision2 = this.pegRevision1;
        }
        DifferencesDialog dialog = new DifferencesDialog(this.getShell(), null, (ISVNResource[])selectedResources, new SVNRevision[]{this.pegRevision1, this.pegRevision2}, this.getTargetPart());
        dialog.setUsePegRevision(this.usePegRevision);
        dialog.setFromUrl(fromUrl);
        dialog.setToUrl(toUrl);
        IResource localResource = null;
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof GenericHistoryView && (historyPage = ((GenericHistoryView)part).getHistoryPage()) instanceof SVNHistoryPage) {
            localResource = ((SVNHistoryPage)historyPage).getResource();
        }
        dialog.setLocalResource(localResource);
        if (!fromRevision.equals("HEAD")) {
            dialog.setFromRevision(fromRevision);
        }
        if (toRevision != null && !toRevision.equals("HEAD")) {
            dialog.setToRevision(toRevision);
        }
        dialog.open();
    }

    @Override
    protected boolean isEnabled() throws TeamException {
        Object[] selectedObjects = this.selection.toArray();
        if (selectedObjects.length == 0 || selectedObjects.length > 2) {
            return false;
        }
        ISVNResource svnResource1 = null;
        ISVNResource svnResource2 = null;
        if (selectedObjects[0] instanceof ISVNResource) {
            svnResource1 = (ISVNResource)selectedObjects[0];
        } else if (selectedObjects[0] instanceof ILogEntry) {
            svnResource1 = ((ILogEntry)selectedObjects[0]).getResource();
        }
        if (svnResource1 == null) {
            return false;
        }
        if (selectedObjects.length > 1) {
            if (selectedObjects[1] instanceof ISVNResource) {
                svnResource2 = (ISVNResource)selectedObjects[1];
            } else if (selectedObjects[1] instanceof ILogEntry) {
                svnResource2 = ((ILogEntry)selectedObjects[1]).getResource();
            }
            if (!svnResource1.getRepository().getRepositoryRoot().toString().equals(svnResource2.getRepository().getRepositoryRoot().toString())) {
                return false;
            }
            return svnResource1.isFolder() == svnResource2.isFolder();
        }
        return true;
    }

    @Override
    protected String getImageId() {
        return "Menu Diff";
    }

    public void setUsePegRevision(boolean usePegRevision) {
        this.usePegRevision = usePegRevision;
    }
}

