/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.UnlockResourcesCommand;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;

public class UnlockAction
extends WorkbenchWindowAction {
    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else if (this.getSelectedResources() != null && this.getSelectedResources().length > 0) {
            final IResource[] resources = this.getSelectedResources();
            this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        try {
                            Hashtable table = UnlockAction.this.getProviderMapping(UnlockAction.this.getSelectedResources());
                            Set keySet = table.keySet();
                            for (SVNTeamProvider provider : keySet) {
                                UnlockResourcesCommand command = new UnlockResourcesCommand(provider.getSVNWorkspaceRoot(), resources, false);
                                command.run(Policy.subMonitorFor(monitor, 1000));
                            }
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }, true, 1);
        }
    }

    @Override
    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) {
        block3: {
            try {
                if (super.isEnabledForSVNResource(svnResource)) break block3;
                return false;
            }
            catch (SVNException sVNException) {
                return false;
            }
        }
        return svnResource.getStatusFromCache().isLocked();
    }

    @Override
    protected String getImageId() {
        return "Menu Lock";
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return false;
    }
}

