/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.util.IPromptCondition;
import org.tigris.subversion.subclipse.ui.util.PromptingDialog;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public abstract class WorkspaceAction
extends SVNAction {
    private String name;

    @Override
    protected boolean needsToSaveDirtyEditors() {
        IResource[] selectedResources = this.getSelectedResources();
        if (selectedResources != null && selectedResources.length > 0) {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if (editorReference.isDirty()) {
                    try {
                        IFile file;
                        IEditorInput editorInput = editorReference.getEditorInput();
                        if (editorInput instanceof IFileEditorInput && this.needsToSave(file = ((IFileEditorInput)editorInput).getFile(), selectedResources)) {
                            return true;
                        }
                    }
                    catch (PartInitException partInitException) {}
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean needsToSave(IFile file, IResource[] selectedResources) {
        if (file != null) {
            IFile parent = file;
            while (parent != null) {
                IResource[] iResourceArray = selectedResources;
                int n = selectedResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource selectedResource = iResourceArray[n2];
                    if (selectedResource.equals((Object)parent)) {
                        return true;
                    }
                    ++n2;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    @Override
    protected boolean isEnabled() throws TeamException {
        IResource[] resources = super.getSelectedResources();
        if (resources.length == 0) {
            return false;
        }
        if (!this.isEnabledForMultipleResources() && resources.length != 1) {
            return false;
        }
        ArrayList<IPath> folderPaths = new ArrayList<IPath>();
        ArrayList<IPath> filePaths = new ArrayList<IPath>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isAccessible() && !this.isEnabledForInaccessibleResources()) {
                return false;
            }
            if (SVNWorkspaceRoot.isLinkedResource((IResource)resource)) {
                return false;
            }
            if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)SVNProviderPlugin.getTypeId()) == null) {
                return false;
            }
            IPath resourceFullPath = resource.getFullPath();
            if (resource.getType() == 1) {
                filePaths.add(resourceFullPath);
            } else {
                folderPaths.add(resourceFullPath);
            }
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            if (!this.isEnabledForSVNResource(svnResource)) {
                return false;
            }
            ++i;
        }
        if (!folderPaths.isEmpty()) {
            for (IPath resourcePath : filePaths) {
                for (IPath folderPath : folderPaths) {
                    if (!folderPath.isPrefixOf(resourcePath)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isEnabledForInaccessibleResources() {
        return false;
    }

    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) throws SVNException {
        if (this.isEnabledForIgnoredResources() && this.isEnabledForManagedResources() && this.isEnabledForUnmanagedResources() && this.isEnabledForAddedResources() && this.isEnabledForCopiedResources()) {
            return true;
        }
        LocalResourceStatus status = svnResource.getStatusFromCache();
        boolean managed = false;
        boolean ignored = false;
        boolean added = false;
        boolean copied = false;
        if (!this.isEnabledForIgnoredResources()) {
            ignored = !status.isManaged() && status.isIgnored() ? true : svnResource.isIgnored();
        }
        if (!ignored && (managed = status.isManaged())) {
            copied = status.isCopied();
            added = status.isAdded();
        }
        if (managed && !this.isEnabledForManagedResources()) {
            return false;
        }
        if (!managed && !this.isEnabledForUnmanagedResources()) {
            return false;
        }
        if (ignored && !this.isEnabledForIgnoredResources()) {
            return false;
        }
        return !(copied && added ? !this.isEnabledForCopiedResources() : added && !this.isEnabledForAddedResources());
    }

    protected boolean isEnabledForIgnoredResources() {
        return false;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForAddedResources() {
        return true;
    }

    protected boolean isEnabledForCopiedResources() {
        return this.isEnabledForAddedResources();
    }

    protected boolean isEnabledForMultipleResources() {
        return true;
    }

    public static IResource[] getNonOverlapping(IResource[] resources) {
        ArrayList<IResource> sorted = new ArrayList<IResource>();
        sorted.addAll(Arrays.asList(resources));
        Collections.sort(sorted, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IResource resource0 = (IResource)arg0;
                IResource resource1 = (IResource)arg1;
                return resource0.getFullPath().segmentCount() - resource1.getFullPath().segmentCount();
            }

            @Override
            public boolean equals(Object arg0) {
                return false;
            }
        });
        ArrayList<IPath> coveredPaths = new ArrayList<IPath>();
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            IPath resourceFullPath = resource.getFullPath();
            boolean covered = false;
            for (IPath path : coveredPaths) {
                if (!path.isPrefixOf(resourceFullPath)) continue;
                covered = true;
            }
            if (covered) {
                iter.remove();
                continue;
            }
            if (resource.getType() != 2) continue;
            coveredPaths.add(resource.getFullPath());
        }
        return sorted.toArray(new IResource[sorted.size()]);
    }

    @Override
    protected IResource[] getSelectedResources() {
        return WorkspaceAction.getNonOverlapping(super.getSelectedResources());
    }

    protected IResource[] getSelectedResources(boolean includeOverlapping) {
        if (includeOverlapping) {
            return super.getSelectedResources();
        }
        return this.getSelectedResources();
    }

    protected IResource[] getModifiedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws SVNException {
        ArrayList<IResource> modified = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            GetStatusCommand command = new GetStatusCommand(svnResource, true, false);
            command.run(iProgressMonitor);
            ISVNStatus[] statuses = command.getStatuses();
            int j = 0;
            while (j < statuses.length) {
                IResource currentResource;
                if ((SVNStatusUtils.isReadyForRevert((ISVNStatus)statuses[j]) || !SVNStatusUtils.isManaged((ISVNStatus)statuses[j])) && (currentResource = SVNWorkspaceRoot.getResourceFor((IResource)resource, (ISVNStatus)statuses[j])) != null) {
                    modified.add(currentResource);
                }
                ++j;
            }
            ++i;
        }
        return modified.toArray(new IResource[modified.size()]);
    }

    protected IResource[] checkOverwriteOfDirtyResources(IResource[] resources) throws SVNException, InterruptedException {
        IResource[] dirtyResources = this.getModifiedResources(resources, null);
        if (dirtyResources == null || dirtyResources.length == 0) {
            return resources;
        }
        PromptingDialog dialog = new PromptingDialog(this.getShell(), dirtyResources, this.getPromptCondition(dirtyResources), Policy.bind("ReplaceWithAction.confirmOverwrite"));
        return dialog.promptForMultiple();
    }

    protected IPromptCondition getPromptCondition(IResource[] resources) {
        return WorkspaceAction.getOverwriteLocalChangesPrompt(resources);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
    }
}

