/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.SVNAbstractCompareEditorInput;
import org.tigris.subversion.subclipse.ui.compare.SummaryDifferencer;
import org.tigris.subversion.subclipse.ui.compare.SummaryEditionNode;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNFolderCompareEditorInput
extends SVNAbstractCompareEditorInput {
    private SummaryEditionNode left;
    private SVNRevision leftPegRevision;
    private SummaryEditionNode right;
    private SVNRevision rightPegRevision;
    private ISVNRemoteFolder folder1;
    private ISVNRemoteFolder folder2;
    private ITypedElement ancestor;
    private Image leftImage;
    private Image rightImage;
    private Image ancestorImage;
    private ISVNResource localResource1;
    private ISVNResource localResource2;

    public SVNFolderCompareEditorInput(ISVNRemoteFolder folder1, SVNRevision pegRevision1, ISVNRemoteFolder folder2, SVNRevision pegRevision2) {
        super(new CompareConfiguration());
        this.folder1 = folder1;
        this.folder2 = folder2;
        this.left = new SummaryEditionNode((ISVNRemoteResource)folder1, pegRevision1);
        this.left.setRootFolder((RemoteFolder)folder1);
        this.left.setNodeType(0);
        this.right = new SummaryEditionNode((ISVNRemoteResource)folder2, pegRevision2);
        this.right.setRootFolder((RemoteFolder)folder2);
        this.right.setNodeType(1);
    }

    private String getLabel(ITypedElement element) {
        if (element instanceof SummaryEditionNode) {
            ISVNRemoteResource edition = ((SummaryEditionNode)element).getRemoteResource();
            return Policy.bind("nameAndRevision", edition.getName(), edition.getRevision().toString());
        }
        return element.getName();
    }

    private String getVersionLabel(ITypedElement element) {
        if (element instanceof SummaryEditionNode) {
            ISVNRemoteResource edition = ((SummaryEditionNode)element).getRemoteResource();
            return edition.getRevision().toString();
        }
        return element.getName();
    }

    private String guessResourceName() {
        if (this.left != null) {
            return this.left.getName();
        }
        if (this.right != null) {
            return this.right.getName();
        }
        if (this.ancestor != null) {
            return this.ancestor.getName();
        }
        return "";
    }

    private void initLabels() {
        String title;
        CompareConfiguration cc = this.getCompareConfiguration();
        SummaryEditionNode left = this.left;
        SummaryEditionNode right = this.right;
        ITypedElement ancestor = this.ancestor;
        if (left != null) {
            cc.setLeftLabel(this.getLabel(left));
            cc.setLeftImage(this.leftImage);
        }
        if (right != null) {
            cc.setRightLabel(this.getLabel(right));
            cc.setRightImage(this.rightImage);
        }
        if (ancestor != null) {
            cc.setAncestorLabel(this.getLabel(ancestor));
            cc.setAncestorImage(this.ancestorImage);
        }
        if (ancestor != null) {
            title = Policy.bind("SVNCompareEditorInput.titleAncestor", new Object[]{this.guessResourceName(), this.getVersionLabel(ancestor), this.getVersionLabel(left), this.getVersionLabel(right)});
        } else {
            String leftName = null;
            if (left != null) {
                leftName = left.getName();
            }
            String rightName = null;
            if (right != null) {
                rightName = right.getName();
            }
            title = leftName != null && !leftName.equals(rightName) ? Policy.bind("SVNCompareEditorInput.titleNoAncestorDifferent", new Object[]{leftName, this.getVersionLabel(left), rightName, this.getVersionLabel(right)}) : Policy.bind("SVNCompareEditorInput.titleNoAncestor", new Object[]{this.guessResourceName(), this.getVersionLabel(left), this.getVersionLabel(right)});
        }
        this.setTitle(title);
    }

    public boolean isSaveNeeded() {
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object prepareInput(IProgressMonitor monitor) throws InterruptedException {
        Object object;
        boolean threeWay;
        boolean bl = threeWay = this.ancestor != null;
        if (this.right == null || this.left == null) {
            this.setMessage(Policy.bind("SVNCompareEditorInput.different"));
            return null;
        }
        this.initLabels();
        Object[] result = new Object[1];
        ISVNClientAdapter svnClient = null;
        try {
            IDiffElement[] diffs;
            monitor.beginTask(Policy.bind("SVNCompareEditorInput.comparing"), 30);
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 30);
            sub.beginTask(Policy.bind("SVNCompareEditorInput.comparing"), 100);
            try {
                svnClient = this.folder1.getRepository().getSVNClient();
                SVNDiffSummary[] diffSummary = null;
                if (this.folder1.getRepositoryRelativePath().equals(this.folder2.getRepositoryRelativePath()) && this.localResource1 != null) {
                    IResource resource1 = this.localResource1.getResource();
                    if (resource1 != null) {
                        SVNRevision pegRevision;
                        ISVNLocalResource svnResource1 = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource1);
                        if (svnResource1 != null && (pegRevision = svnResource1.getRevision()) != null) {
                            diffSummary = svnClient.diffSummarize(this.folder1.getUrl(), pegRevision, this.folder2.getRevision(), this.folder1.getRevision(), 5, true);
                        }
                    } else {
                        diffSummary = svnClient.diffSummarize(this.folder1.getUrl(), SVNRevision.HEAD, this.folder2.getRevision(), this.folder1.getRevision(), 5, true);
                    }
                }
                if (diffSummary == null) {
                    diffSummary = svnClient.diffSummarize(this.folder1.getUrl(), this.folder1.getRevision(), this.folder2.getUrl(), this.folder2.getRevision(), 5, true);
                }
                diffSummary = this.getDiffSummaryWithSubfolders(diffSummary);
                this.left.setDiffSummary(diffSummary);
                this.right.setDiffSummary(diffSummary);
                this.left.setRoot(true);
                this.right.setRoot(true);
                result[0] = new SummaryDifferencer().findDifferences(threeWay, (IProgressMonitor)sub, null, this.ancestor, this.left, this.right);
            }
            finally {
                sub.done();
            }
            if (result[0] instanceof DiffNode && ((diffs = ((DiffNode)result[0]).getChildren()) == null || diffs.length == 0)) {
                result[0] = null;
            }
            object = result[0];
            this.folder1.getRepository().returnSVNClient(svnClient);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
            catch (Exception e2) {
                String string = e2.getMessage();
                return string;
            }
        }
        monitor.done();
        return object;
        finally {
            this.folder1.getRepository().returnSVNClient(svnClient);
            monitor.done();
        }
    }

    private SVNDiffSummary[] getDiffSummaryWithSubfolders(SVNDiffSummary[] diffSummary) {
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<SVNDiffSummary> diffs = new ArrayList<SVNDiffSummary>();
        int i = 0;
        while (i < diffSummary.length) {
            paths.add(diffSummary[i].getPath());
            diffs.add(diffSummary[i]);
            ++i;
        }
        i = 0;
        while (i < diffSummary.length) {
            File file = new File(diffSummary[i].getPath());
            while (file.getParentFile() != null) {
                file = file.getParentFile();
                String path = file.getPath();
                if (paths.contains(path = path.replaceAll("\\\\", "/"))) continue;
                paths.add(path);
                SVNDiffSummary folder = new SVNDiffSummary(path, SVNDiffSummary.SVNDiffKind.NORMAL, false, SVNNodeKind.DIR.toInt());
                diffs.add(folder);
            }
            ++i;
        }
        diffSummary = new SVNDiffSummary[diffs.size()];
        diffs.toArray(diffSummary);
        return diffSummary;
    }

    public void setLocalResource1(ISVNResource localResource1) {
        this.localResource1 = localResource1;
    }

    public void setLocalResource2(ISVNResource localResource2) {
        this.localResource2 = localResource2;
    }

    public boolean canRunAsJob() {
        return true;
    }
}

