/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.tigris.subversion.subclipse.core.util.File2Resource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.internal.Utilities;
import org.tigris.subversion.subclipse.ui.conflicts.ConflictWizardDialog;
import org.tigris.subversion.subclipse.ui.conflicts.DialogWizard;
import org.tigris.subversion.subclipse.ui.conflicts.FileNode;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;

public class BuiltInConflictsCompareInput
extends CompareEditorInput {
    private Object fRoot;
    private FileNode fAncestor;
    private FileNode fLeft;
    private FileNode fRight;
    private File fAncestorFile;
    private File fMineFile;
    private File fTheirsFile;
    private File fDestinationFile;
    private String fileName;
    private boolean neverSaved = true;
    private boolean isSaving = false;
    private boolean finished;
    private boolean resolved;
    private int resolution;
    private SVNConflictDescriptor conflictDescriptor;

    public BuiltInConflictsCompareInput(CompareConfiguration configuration, SVNConflictDescriptor conflictDescriptor) {
        super(configuration);
        this.conflictDescriptor = conflictDescriptor;
    }

    public void setResources(File ancestor, File mine, File theirs, File destination, String fileName) {
        this.fAncestorFile = ancestor;
        this.fMineFile = mine;
        this.fTheirsFile = theirs;
        this.fDestinationFile = destination;
        this.fileName = fileName;
        this.initializeCompareConfiguration();
    }

    private String getType() {
        FileNode node = new FileNode(this.fMineFile);
        String s = node.getType();
        if (s != null) {
            return s;
        }
        return "???";
    }

    private void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftEditable(true);
        String leftLabel = "Merged - " + this.fileName;
        String rightLabel = "Theirs - " + this.fileName;
        String ancestorLabel = "Ancestor -" + this.fileName;
        cc.setLeftLabel(leftLabel);
        cc.setRightLabel(rightLabel);
        cc.setAncestorLabel(ancestorLabel);
    }

    protected Object prepareInput(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        try {
            byte[] contents;
            pm.beginTask(Utilities.getString("ResourceCompare.taskName"), -1);
            String charSet = this.getCharSet();
            this.fAncestor = new FileNode(this.fAncestorFile){

                @Override
                public String getType() {
                    return BuiltInConflictsCompareInput.this.getType();
                }

                @Override
                public boolean isEditable() {
                    return false;
                }
            };
            this.fAncestor.setCharSet(charSet);
            this.fLeft = new FileNode(this.fDestinationFile){

                @Override
                public String getType() {
                    return BuiltInConflictsCompareInput.this.getType();
                }
            };
            this.fLeft.setCharSet(charSet);
            FileInputStream mineContents = new FileInputStream(this.fMineFile);
            try {
                contents = new byte[((InputStream)mineContents).available()];
                ((InputStream)mineContents).read(contents);
            }
            finally {
                ((InputStream)mineContents).close();
            }
            this.fLeft.setContent(contents);
            this.fLeft.addContentChangeListener(new IContentChangeListener(){

                public void contentChanged(IContentChangeNotifier source) {
                    if (!BuiltInConflictsCompareInput.this.isSaving) {
                        try {
                            BuiltInConflictsCompareInput.this.saveChanges((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            this.fRight = new FileNode(this.fTheirsFile){

                @Override
                public String getType() {
                    return BuiltInConflictsCompareInput.this.getType();
                }

                @Override
                public boolean isEditable() {
                    return false;
                }
            };
            this.fRight.setCharSet(charSet);
            String title = String.valueOf(Policy.bind("BuiltInConflictsCompareInput.0")) + this.fileName;
            this.setTitle(title);
            Differencer d = new Differencer(){

                protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
                    return new MyDiffNode((IDiffContainer)data, result, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            Object object = this.fRoot = d.findDifferences(true, pm, null, (Object)this.fAncestor, (Object)this.fLeft, (Object)this.fRight);
            return object;
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            pm.done();
        }
    }

    private String getCharSet() {
        String charSet = null;
        String destFilePath = this.fDestinationFile.getAbsolutePath();
        int index = destFilePath.indexOf(String.valueOf(File.separator) + Policy.bind("BuiltInConflictsCompareInput.1") + File.separator);
        String workspacePath = index == -1 ? destFilePath : String.valueOf(destFilePath.substring(0, index)) + File.separator + this.fileName;
        File workspaceFile = new File(workspacePath);
        IFile destinationFile = (IFile)File2Resource.getResource((File)workspaceFile);
        if (destinationFile != null) {
            try {
                charSet = destinationFile.getCharset();
            }
            catch (CoreException coreException) {}
        }
        return charSet;
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        try {
            this.isSaving = true;
            super.saveChanges(pm);
            this.fLeft.commit(pm);
            this.neverSaved = false;
            ((MyDiffNode)((Object)this.fRoot)).fireChange();
        }
        finally {
            this.isSaving = false;
        }
    }

    public boolean isSaveNeeded() {
        if (this.neverSaved) {
            return true;
        }
        return super.isSaveNeeded();
    }

    public Control createContents(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BuiltInConflictsCompareInput.this.handleInternalDispose();
            }
        });
        return super.createContents(parent);
    }

    protected void handleInternalDispose() {
        DialogWizard dialogWizard = new DialogWizard(1);
        dialogWizard.setConflictDescriptor(this.conflictDescriptor);
        ConflictWizardDialog dialog = new ConflictWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard);
        dialog.open();
        this.resolution = dialogWizard.getResolution();
        this.resolved = this.resolution != 0;
        this.finished = true;
    }

    public void handleExternalDispose() {
        DialogWizard dialogWizard = new DialogWizard(1);
        dialogWizard.setConflictDescriptor(this.conflictDescriptor);
        ConflictWizardDialog dialog = new ConflictWizardDialog(Display.getDefault().getActiveShell(), (IWizard)dialogWizard);
        dialog.open();
        this.resolution = dialogWizard.getResolution();
        this.resolved = this.resolution != 0;
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public int getResolution() {
        return this.resolution;
    }

    public static class MyDiffNode
    extends DiffNode {
        public MyDiffNode(IDiffContainer parent, int kind, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, kind, ancestor, left, right);
        }

        public void fireChange() {
            super.fireChange();
        }
    }
}

