/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.Branches;
import org.tigris.subversion.subclipse.core.history.Tags;
import org.tigris.subversion.subclipse.core.repo.ISVNListener;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.RepositoryRootFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.CreateRemoteFolderAction;
import org.tigris.subversion.subclipse.ui.actions.DeleteRemoteResourceAction;
import org.tigris.subversion.subclipse.ui.dialogs.SubclipseTrayDialog;
import org.tigris.subversion.subclipse.ui.repository.RepositoryFilters;
import org.tigris.subversion.subclipse.ui.repository.model.AllRootsElement;
import org.tigris.subversion.subclipse.ui.repository.model.RemoteContentProvider;

public class ChooseUrlDialog
extends SubclipseTrayDialog {
    private static final int LIST_HEIGHT_HINT = 250;
    private static final int LIST_WIDTH_HINT = 450;
    private TreeViewer treeViewer;
    private Action refreshAction;
    private Action newFolderAction;
    private Action deleteFolderAction;
    private String url;
    private String name;
    private String[] urls;
    private String[] names;
    private IResource resource;
    private String message;
    private boolean multipleSelect = false;
    private ISVNRepositoryLocation repositoryLocation;
    private boolean foldersOnly = false;
    private boolean includeBranchesAndTags = true;
    private IDialogSettings settings;
    private RemoteContentProvider contentProvider;
    private static boolean needsRefresh = true;
    private boolean saveLocation = true;

    static {
        ISVNListener repositoryListener = new ISVNListener(){

            public void remoteResourceCopied(ISVNRemoteResource source, ISVNRemoteFolder destination) {
                needsRefresh = true;
            }

            public void remoteResourceCreated(ISVNRemoteFolder parent, String resourceName) {
                needsRefresh = true;
            }

            public void remoteResourceDeleted(ISVNRemoteResource resource) {
                needsRefresh = true;
            }

            public void remoteResourceMoved(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String destinationResourceName) {
                needsRefresh = true;
            }

            public void repositoryAdded(ISVNRepositoryLocation root) {
                needsRefresh = true;
            }

            public void repositoryModified(ISVNRepositoryLocation root) {
                needsRefresh = true;
            }

            public void repositoryRemoved(ISVNRepositoryLocation root) {
                needsRefresh = true;
            }
        };
        SVNProviderPlugin.getPlugin().getRepositoryResourcesManager().addRepositoryListener(repositoryListener);
    }

    public ChooseUrlDialog(Shell parentShell, IResource resource) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.resource = resource;
        this.refreshAction = new Action(Policy.bind("ChooseUrlDialog.refresh"), SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                ChooseUrlDialog.this.refreshViewer(true);
            }
        };
        this.newFolderAction = new Action(Policy.bind("NewRemoteFolderWizard.title")){

            public void run() {
                CreateRemoteFolderAction createAction = new CreateRemoteFolderAction();
                createAction.selectionChanged(null, ChooseUrlDialog.this.treeViewer.getSelection());
                createAction.run(null);
                ChooseUrlDialog.this.refreshViewer(true);
            }
        };
        this.deleteFolderAction = new Action(Policy.bind("ChooseUrlDialog.delete")){

            public void run() {
                DeleteRemoteResourceAction deleteAction = new DeleteRemoteResourceAction();
                deleteAction.selectionChanged(null, ChooseUrlDialog.this.treeViewer.getSelection());
                deleteAction.run(null);
                ChooseUrlDialog.this.refreshViewer(true);
            }
        };
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        if (needsRefresh) {
            this.refreshRepositoriesFolders();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("ChooseUrlDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        if (this.message != null) {
            Label messageLabel = new Label(composite, 0);
            messageLabel.setText(this.message);
        }
        this.treeViewer = this.multipleSelect ? new TreeViewer(composite, 2818) : new TreeViewer(composite, 2816);
        this.contentProvider = new RemoteContentProvider();
        this.contentProvider.setIncludeBranchesAndTags(this.includeBranchesAndTags);
        this.contentProvider.setResource(this.resource);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        if (this.foldersOnly) {
            this.treeViewer.addFilter(RepositoryFilters.FOLDERS_ONLY);
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RemoteLabelProvider());
        ISVNRepositoryLocation repository = null;
        if (this.repositoryLocation == null) {
            if (this.resource == null) {
                this.treeViewer.setInput((Object)new AllRootsElement());
            } else {
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
                try {
                    LocalResourceStatus status = svnResource.getStatus();
                    if (status != null) {
                        repository = svnResource.getStatus().getRepository();
                    }
                }
                catch (SVNException sVNException) {}
                if (repository == null) {
                    repository = svnResource.getRepository();
                }
                if (!repository.getUrl().toString().equals(repository.getRepositoryRoot().toString())) {
                    RepositoryRootFolder rootFolder = new RepositoryRootFolder(repository, repository.getRepositoryRoot(), repository.getRootFolder().getRevision());
                    this.contentProvider.setRootFolder((RemoteFolder)rootFolder);
                }
            }
        } else {
            repository = this.repositoryLocation;
        }
        if (repository == null) {
            this.treeViewer.setInput((Object)new AllRootsElement());
        } else {
            try {
                repository.validateConnection((IProgressMonitor)new NullProgressMonitor());
                this.treeViewer.setInput((Object)repository);
            }
            catch (SVNException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("ChooseUrlDialog.title"), (String)e.getMessage());
                this.saveLocation = false;
                this.cancelPressed();
                return composite;
            }
        }
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 450;
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    ChooseUrlDialog.this.refreshAction.run();
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ChooseUrlDialog.this.okPressed();
            }
        });
        MenuManager menuMgr = new MenuManager();
        Tree tree = this.treeViewer.getTree();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)ChooseUrlDialog.this.newFolderAction);
                if (!ChooseUrlDialog.this.treeViewer.getSelection().isEmpty()) {
                    manager.add((IAction)ChooseUrlDialog.this.deleteFolderAction);
                }
                manager.add((IAction)ChooseUrlDialog.this.refreshAction);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.choose_url_dialog_context");
        return composite;
    }

    public int open() {
        try {
            return super.open();
        }
        catch (Exception exception) {
            return 1;
        }
    }

    protected void refreshViewer(boolean refreshRepositoriesFolders) {
        if (this.treeViewer == null) {
            return;
        }
        this.contentProvider.setUseDeferredContentManager(false);
        Object[] expandedObjects = this.treeViewer.getExpandedElements();
        if (refreshRepositoriesFolders) {
            this.refreshRepositoriesFolders();
        }
        this.treeViewer.refresh();
        this.treeViewer.setExpandedElements(expandedObjects);
        this.contentProvider.setUseDeferredContentManager(true);
    }

    private void refreshRepositoriesFolders() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SVNProviderPlugin.getPlugin().getRepositories().refreshRepositoriesFolders(monitor);
                needsRefresh = false;
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, runnable);
        }
        catch (Exception e) {
            SVNUIPlugin.openError(this.getShell(), null, null, e, 2);
        }
    }

    protected void okPressed() {
        this.saveLocation();
        ISelection selection = this.treeViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object first = structured.getFirstElement();
            if (first instanceof ISVNRemoteResource) {
                this.url = ((ISVNRemoteResource)first).getUrl().toString();
                this.name = ((ISVNRemoteResource)first).getName();
            }
            if (first instanceof ISVNRepositoryLocation) {
                this.url = ((ISVNRepositoryLocation)first).getUrl().toString();
            }
            if (first instanceof Alias) {
                this.url = AliasManager.transformUrl((IResource)this.resource, (Alias)((Alias)first));
            }
            ArrayList<String> urlArray = new ArrayList<String>();
            ArrayList<String> nameArray = new ArrayList<String>();
            for (Object selectedItem : structured) {
                if (!(selectedItem instanceof ISVNRemoteResource)) continue;
                urlArray.add(((ISVNRemoteResource)selectedItem).getUrl().toString());
                nameArray.add(((ISVNRemoteResource)selectedItem).getName());
            }
            this.urls = new String[urlArray.size()];
            urlArray.toArray(this.urls);
            this.names = new String[nameArray.size()];
            nameArray.toArray(this.names);
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.saveLocation) {
            this.saveLocation();
        }
        super.cancelPressed();
    }

    private void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put("ChooseUrlDialog.location.x", x);
        this.settings.put("ChooseUrlDialog.location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put("ChooseUrlDialog.size.x", x);
        this.settings.put("ChooseUrlDialog.size.y", y);
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt("ChooseUrlDialog.location.x");
            int y = this.settings.getInt("ChooseUrlDialog.location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt("ChooseUrlDialog.size.x");
            int y = this.settings.getInt("ChooseUrlDialog.size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setRepositoryLocation(ISVNRepositoryLocation repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public void setFoldersOnly(boolean foldersOnly) {
        this.foldersOnly = foldersOnly;
    }

    public void setIncludeBranchesAndTags(boolean includeBranchesAndTags) {
        this.includeBranchesAndTags = includeBranchesAndTags;
    }

    public String getName() {
        return this.name;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMultipleSelect(boolean multipleSelect) {
        this.multipleSelect = multipleSelect;
    }

    public String[] getNames() {
        return this.names;
    }

    public String[] getUrls() {
        return this.urls;
    }

    class RemoteLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider {
        private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        RemoteLabelProvider() {
        }

        public Color getForeground(Object element) {
            return this.workbenchLabelProvider.getForeground(element);
        }

        public Color getBackground(Object element) {
            return this.workbenchLabelProvider.getBackground(element);
        }

        public Font getFont(Object element) {
            return this.workbenchLabelProvider.getFont(element);
        }

        public Image getImage(Object element) {
            if (element instanceof Branches) {
                return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/branches_rep.gif").createImage();
            }
            if (element instanceof Tags) {
                return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/versions_rep.gif").createImage();
            }
            if (element instanceof Alias) {
                if (((Alias)element).isBranch()) {
                    return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/tag.gif").createImage();
                }
                return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/prjversions_rep.gif").createImage();
            }
            if (element instanceof RepositoryRootFolder) {
                return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/repository_rep.gif").createImage();
            }
            return this.workbenchLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof Branches) {
                return Policy.bind("ChooseUrlDialog.branches");
            }
            if (element instanceof Tags) {
                return Policy.bind("ChooseUrlDialog.tags");
            }
            if (element instanceof Alias) {
                return ((Alias)element).getName();
            }
            return this.workbenchLabelProvider.getText(element);
        }
    }
}

