/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CommitOperation
extends SVNOperation {
    private IResource[] resourcesToAdd;
    private IResource[] resourcesToDelete;
    private IResource[] resourcesToCommit;
    private String commitComment;
    private boolean keepLocks;
    private ISVNClientAdapter svnClient;
    private boolean atomicCommit = true;
    private boolean canRunAsJob = true;
    private String postCommitError;
    private static final String DELETED_FOLDERS = "deletedFolders";
    private static final String NOT_DELETED_FOLDERS = "notDeletedFolders";
    private static final String PROPERTY_CHANGE_FOLDERS = "propChangeFolders";

    public CommitOperation(IWorkbenchPart part, IResource[] selectedResources, IResource[] resourcesToAdd, IResource[] resourcesToDelete, IResource[] resourcesToCommit, String commitComment, boolean keepLocks) {
        super(part);
        this.resourcesToAdd = resourcesToAdd;
        this.resourcesToDelete = resourcesToDelete;
        this.resourcesToCommit = resourcesToCommit;
        this.commitComment = commitComment;
        this.keepLocks = keepLocks;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        this.postCommitError = null;
        monitor.beginTask(null, this.resourcesToAdd.length + this.resourcesToDelete.length + this.resourcesToCommit.length);
        try {
            try {
                List<IResource> list;
                Set<Object> keySet;
                Map<Object, List<IResource>> table;
                this.svnClient = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                if (this.resourcesToAdd.length > 0) {
                    table = this.getProviderMapping(this.resourcesToAdd);
                    if (table.get(null) != null) {
                        throw new SVNException(Policy.bind("RepositoryManager.addErrorNotAssociated"));
                    }
                    keySet = table.keySet();
                    for (SVNTeamProvider sVNTeamProvider : keySet) {
                        List<IResource> list2 = table.get(sVNTeamProvider);
                        IResource[] providerResources = list2.toArray(new IResource[list2.size()]);
                        sVNTeamProvider.add(providerResources, 0, Policy.subMonitorFor(monitor, this.resourcesToAdd.length));
                    }
                }
                if (this.resourcesToDelete.length > 0) {
                    ISVNClientAdapter svnDeleteClient = null;
                    try {
                        try {
                            Map<SVNTeamProvider, List<IResource>> table2 = this.getProviderMapping(this.resourcesToDelete);
                            if (table2.get(null) != null) {
                                throw new SVNException(Policy.bind("RepositoryManager.addErrorNotAssociated"));
                            }
                            Set<SVNTeamProvider> set = table2.keySet();
                            for (SVNTeamProvider provider : set) {
                                list = table2.get(provider);
                                File[] files = new File[list.size()];
                                int i = 0;
                                for (IResource resource : list) {
                                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                                    if (svnDeleteClient == null) {
                                        svnDeleteClient = svnResource.getRepository().getSVNClient();
                                    }
                                    files[i] = svnResource.getFile();
                                    ++i;
                                }
                                svnDeleteClient.remove(files, true);
                            }
                        }
                        catch (SVNClientException e) {
                            throw new TeamException(e.getMessage());
                        }
                    }
                    finally {
                        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnDeleteClient);
                    }
                }
                this.setAtomicCommitMode();
                table = this.getCommitProviderMapping(this.resourcesToCommit);
                keySet = table.keySet();
                for (ProjectAndRepository projectAndRepository : keySet) {
                    SVNTeamProvider provider = projectAndRepository.getTeamProvider();
                    list = table.get(projectAndRepository);
                    IResource[] providerResources = new IResource[list.size()];
                    list.toArray(providerResources);
                    this.postCommitError = provider.checkin(providerResources, this.commitComment, this.keepLocks, 0, Policy.subMonitorFor(monitor, providerResources.length));
                    IResource[] iResourceArray = providerResources;
                    int n = providerResources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource providerResource = iResourceArray[n2];
                        if (!providerResource.exists()) {
                            SVNProviderPlugin.getPlugin().getStatusCacheManager().removeStatus(providerResource);
                        }
                        ++n2;
                    }
                    if (this.postCommitError == null) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind("CommitDialog.title"), (String)CommitOperation.this.postCommitError);
                        }
                    });
                }
            }
            catch (TeamException e) {
                throw SVNException.wrapException((TeamException)e);
            }
        }
        finally {
            monitor.done();
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(this.svnClient);
            SVNProviderPlugin.broadcastModificationStateChanges((IResource[])this.resourcesToCommit);
        }
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("CommitOperation.taskName");
    }

    private Map<ProjectAndRepository, List<IResource>> getCommitProviderMapping(IResource[] resources) {
        ProjectAndRepository mapKey = null;
        HashMap<ProjectAndRepository, List<IResource>> result = new HashMap<ProjectAndRepository, List<IResource>>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<IResource> list;
            IResource resource = iResourceArray[n2];
            if (mapKey == null || !this.svnClient.canCommitAcrossWC()) {
                SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)SVNProviderPlugin.getTypeId());
                mapKey = new ProjectAndRepository(provider, this.getRootURL(SVNWorkspaceRoot.getSVNResourceFor((IResource)resource)));
            }
            if ((list = (ArrayList<IResource>)result.get(mapKey)) == null) {
                list = new ArrayList<IResource>();
                result.put(mapKey, list);
            }
            list.add(resource);
            ++n2;
        }
        return result;
    }

    private Map<SVNTeamProvider, List<IResource>> getProviderMapping(IResource[] resources) {
        SVNTeamProvider provider = null;
        HashMap<SVNTeamProvider, List<IResource>> result = new HashMap<SVNTeamProvider, List<IResource>>();
        int i = 0;
        while (i < resources.length) {
            ArrayList<IResource> list;
            if (provider == null || !this.svnClient.canCommitAcrossWC()) {
                provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)resources[i].getProject(), (String)SVNProviderPlugin.getTypeId());
            }
            if ((list = (ArrayList<IResource>)result.get(provider)) == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    private String getRootURL(ISVNLocalResource localResource) {
        if (!this.atomicCommit) {
            return null;
        }
        ISVNInfo info = this.getSVNInfo(localResource);
        if (info == null) {
            return null;
        }
        SVNUrl repos = info.getRepository();
        if (repos == null) {
            return null;
        }
        return repos.toString();
    }

    private ISVNInfo getSVNInfo(ISVNLocalResource localResource) {
        ISVNInfo info;
        boolean returnSVNClient;
        if (!this.atomicCommit) {
            return null;
        }
        if (localResource == null) {
            return null;
        }
        File file = localResource.getFile();
        if (file == null) {
            return null;
        }
        boolean bl = returnSVNClient = this.svnClient == null;
        if (this.svnClient == null) {
            try {
                this.svnClient = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
            }
            catch (SVNException sVNException) {
                return null;
            }
        }
        try {
            try {
                SVNProviderPlugin.disableConsoleLogging();
                info = this.svnClient.getInfoFromWorkingCopy(file);
                SVNProviderPlugin.enableConsoleLogging();
            }
            catch (SVNClientException sVNClientException) {
                SVNProviderPlugin.enableConsoleLogging();
                if (returnSVNClient) {
                    SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(this.svnClient);
                }
                return null;
            }
        }
        finally {
            if (returnSVNClient) {
                SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(this.svnClient);
            }
        }
        return info;
    }

    @Override
    protected boolean canRunAsJob() {
        return this.canRunAsJob;
    }

    private void setAtomicCommitMode() {
        if (!SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_use_javahl_commit_hack")) {
            this.atomicCommit = false;
            return;
        }
        if (this.svnClient.canCommitAcrossWC()) {
            this.atomicCommit = false;
            return;
        }
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }

    protected class ProjectAndRepository {
        private SVNTeamProvider provider;
        private String rootURL;

        public ProjectAndRepository(SVNTeamProvider provider, String rootURL) {
            this.provider = provider;
            this.rootURL = rootURL == null ? "" : rootURL;
        }

        public SVNTeamProvider getTeamProvider() {
            return this.provider;
        }

        public String getRootURL() {
            return this.rootURL;
        }

        private String getKey() {
            return this.rootURL;
        }

        public String toString() {
            return this.getKey();
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectAndRepository other = (ProjectAndRepository)obj;
            return this.getKey().equals(other.getKey());
        }
    }
}

