/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class ExportRemoteFolderOperation
extends SVNOperation {
    private ISVNRemoteResource folder;
    private File directory;
    private SVNRevision revision;

    public ExportRemoteFolderOperation(IWorkbenchPart part, ISVNRemoteResource folder, File directory, SVNRevision revision) {
        super(part);
        this.folder = folder;
        this.directory = directory;
        this.revision = revision;
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("ExportOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("ExportOperation.0", provider.getProject().getName());
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        ISVNClientAdapter client = null;
        try {
            try {
                client = this.folder.getRepository().getSVNClient();
                try {
                    client.doExport(this.folder.getUrl(), this.directory, this.revision, true);
                }
                catch (SVNClientException e) {
                    throw SVNException.wrapException((Exception)((Object)e));
                }
            }
            catch (SVNException e) {
                if (e.operationInterrupted()) {
                    this.showCancelledMessage();
                } else {
                    this.collectStatus(e.getStatus());
                }
                this.folder.getRepository().returnSVNClient(client);
                monitor.done();
            }
        }
        finally {
            this.folder.getRepository().returnSVNClient(client);
            monitor.done();
        }
    }
}

