/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.repository;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ViewerSorter;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;

public class RepositorySorter
extends ViewerSorter {
    private static final int REPO_ROOT_CATEGORY = 1;
    private static final int REMOTE_FOLDER_CATEGORY = 2;
    private static final int REMOTE_FILE_CATEGORY = 3;
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.?)+");
    private static final Pattern VERSION_SEPARATOR_PATTERN = Pattern.compile("\\.");
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            try {
                Matcher m1 = VERSION_PATTERN.matcher(s1);
                Matcher m2 = VERSION_PATTERN.matcher(s2);
                int beginningS1 = 0;
                int beginningS2 = 0;
                while (m1.find() && m2.find()) {
                    String preVersion2;
                    String preVersion1 = s1.substring(beginningS1, m1.start());
                    if (preVersion1.compareTo(preVersion2 = s2.substring(beginningS2, m2.start())) == 0) {
                        String version1 = s1.substring(m1.start(), m1.end());
                        String version2 = s2.substring(m2.start(), m2.end());
                        String[] versionsMax = VERSION_SEPARATOR_PATTERN.split(version1);
                        String[] versionsMin = VERSION_SEPARATOR_PATTERN.split(version2);
                        int inverter = 1;
                        if (Math.max(versionsMax.length, versionsMin.length) != versionsMax.length) {
                            String[] temp = versionsMax;
                            versionsMax = versionsMin;
                            versionsMin = temp;
                            inverter = -1;
                        }
                        int i = 0;
                        while (i < versionsMax.length) {
                            Integer digit2;
                            if (versionsMin.length == i) {
                                return 1 * inverter;
                            }
                            if (versionsMax[i].length() > 5 || versionsMin[i].length() > 5) {
                                return s1.compareTo(s2);
                            }
                            Integer digit1 = Integer.parseInt(versionsMax[i]);
                            if (digit1.compareTo(digit2 = Integer.valueOf(Integer.parseInt(versionsMin[i]))) != 0) {
                                return digit1.compareTo(digit2) * inverter;
                            }
                            ++i;
                        }
                        beginningS1 = m1.end();
                        beginningS2 = m2.end();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {}
            return s1.compareToIgnoreCase(s2);
        }
    };

    public int category(Object element) {
        if (element instanceof ISVNRepositoryLocation) {
            return 1;
        }
        if (element instanceof ISVNRemoteFolder) {
            return 2;
        }
        if (element instanceof ISVNRemoteFile) {
            return 3;
        }
        return 0;
    }

    protected Comparator getComparator() {
        return COMPARATOR;
    }
}

