/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.IgnoreResourcesDialog;
import org.tigris.subversion.subclipse.ui.operations.IgnoreOperation;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;

public class IgnoreSynchronizeOperation
extends SVNSynchronizeOperation {
    private IResource[] resources;
    private IgnoreResourcesDialog ignoreResourcesDialog;
    private boolean cancel;

    public IgnoreSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, IResource[] resources) {
        super(configuration, elements);
        this.resources = resources;
    }

    @Override
    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        if (!this.promptForConflictHandling(this.getShell(), syncSet)) {
            return;
        }
        Map projectSyncInfos = this.getProjectSyncInfoSetMap(syncSet);
        monitor.beginTask(null, projectSyncInfos.size() * 100);
        for (IProject project : projectSyncInfos.keySet()) {
            SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.tigris.subversion.subclipse.core.svnnature");
            if (provider == null) continue;
            this.run(provider, (SyncInfoSet)projectSyncInfos.get(project), Policy.subMonitorFor(monitor, 100));
            break;
        }
        monitor.done();
    }

    @Override
    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IgnoreSynchronizeOperation.this.ignoreResourcesDialog = new IgnoreResourcesDialog(IgnoreSynchronizeOperation.this.getShell(), IgnoreSynchronizeOperation.this.resources);
                IgnoreSynchronizeOperation.this.cancel = IgnoreSynchronizeOperation.this.ignoreResourcesDialog.open() == 1;
            }
        });
        if (this.cancel) {
            return;
        }
        new IgnoreOperation(this.getPart(), this.resources, this.ignoreResourcesDialog).run();
    }
}

