/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.RemoteResourceStatus;
import org.tigris.subversion.subclipse.core.sync.SVNStatusSyncInfo;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNChangeSetCollector
extends SyncInfoSetChangeSetCollector {
    public SVNChangeSetCollector(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    protected void add(final SyncInfo[] infos) {
        final HashMap sets = new HashMap();
        Job job = new Job(Policy.bind("SynchronizeView.collectingChangeSets")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(null, infos.length);
                int i = 0;
                while (i < infos.length) {
                    SVNStatusSyncInfo svnSyncInfo;
                    SyncInfo syncInfo = infos[i];
                    if (syncInfo instanceof SVNStatusSyncInfo && SyncInfo.getDirection((int)(svnSyncInfo = (SVNStatusSyncInfo)syncInfo).getKind()) == 8 && svnSyncInfo.getRemote() != null) {
                        SVNCheckedInChangeSet changeSet = (SVNCheckedInChangeSet)((Object)sets.get(svnSyncInfo.getRemote().getContentIdentifier()));
                        if (changeSet == null) {
                            changeSet = new SVNCheckedInChangeSet((SyncInfo)svnSyncInfo);
                            sets.put(svnSyncInfo.getRemote().getContentIdentifier(), changeSet);
                        } else {
                            changeSet.add((SyncInfo)svnSyncInfo);
                        }
                    }
                    monitor.worked(1);
                    ++i;
                }
                monitor.done();
                SVNChangeSetCollector.this.performUpdate(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        for (SVNCheckedInChangeSet set : sets.values()) {
                            SVNChangeSetCollector.this.add((ChangeSet)set);
                        }
                    }
                }, true, (IProgressMonitor)new NullProgressMonitor());
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private String flattenComment(String string) {
        StringBuffer buffer = new StringBuffer(string.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                if (!skipAdjacentLineSeparator) {
                    buffer.append(Policy.bind("separator"));
                }
                skipAdjacentLineSeparator = true;
            } else {
                buffer.append(c);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return buffer.toString();
    }

    protected void initializeSets() {
    }

    public class SVNCheckedInChangeSet
    extends CheckedInChangeSet {
        private long revision;
        private String author;
        private Date date;
        private String comment;

        public SVNCheckedInChangeSet(SyncInfo info) {
            this(new SyncInfo[]{info});
        }

        public SVNCheckedInChangeSet(SyncInfo[] infos) {
            this.add(infos);
            this.initData();
            String formattedDate = this.date == null ? "n/a" : DateFormat.getInstance().format(this.date);
            this.setName(String.valueOf(this.revision) + "  [" + this.author + "]  (" + formattedDate + ")  " + this.comment);
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public long getRevision() {
            return this.revision;
        }

        private void initData() {
            SyncInfo syncInfo;
            this.revision = -1L;
            SyncInfoTree syncInfoTree = this.getSyncInfoSet();
            SyncInfo[] syncInfos = syncInfoTree.getSyncInfos();
            if (syncInfos.length > 0 && (syncInfo = syncInfos[0]) instanceof SVNStatusSyncInfo) {
                SVNStatusSyncInfo svnSyncInfo = (SVNStatusSyncInfo)syncInfo;
                RemoteResourceStatus remoteResourceStatus = svnSyncInfo.getRemoteResourceStatus();
                if (remoteResourceStatus != null) {
                    SVNRevision.Number revnum = remoteResourceStatus.getLastChangedRevision();
                    this.revision = revnum != null ? revnum.getNumber() : SVNRevision.INVALID_REVISION.getNumber();
                    this.author = remoteResourceStatus.getLastCommitAuthor();
                    if (this.author == null || this.author.length() == 0) {
                        this.author = Policy.bind("SynchronizeView.noAuthor");
                    }
                    this.date = remoteResourceStatus.getLastChangedDate();
                    this.comment = this.fetchComment(svnSyncInfo);
                } else {
                    this.revision = SVNRevision.INVALID_REVISION.getNumber();
                    this.author = Policy.bind("SynchronizeView.noAuthor");
                    this.comment = "";
                    this.date = null;
                }
            }
        }

        private String fetchComment(SVNStatusSyncInfo info) {
            String fetchedComment = Policy.bind("SynchronizeView.standardIncomingChangeSetComment");
            IResourceVariant remoteResource = info.getRemote();
            if (remoteResource instanceof ISVNRemoteResource) {
                ISVNRemoteResource svnRemoteResource = (ISVNRemoteResource)remoteResource;
                ISVNClientAdapter client = null;
                try {
                    try {
                        client = svnRemoteResource.getRepository().getSVNClient();
                        SVNUrl url = svnRemoteResource.getRepository().getRepositoryRoot();
                        SVNRevision.Number rev = svnRemoteResource.getLastChangedRevision();
                        ISVNLogMessage[] logMessages = client.getLogMessages(url, (SVNRevision)rev, (SVNRevision)rev, false);
                        if (logMessages.length != 0) {
                            String logComment = logMessages[0].getMessage();
                            fetchedComment = logComment.trim().length() != 0 ? SVNChangeSetCollector.this.flattenComment(logComment) : "";
                        }
                    }
                    catch (SVNException e1) {
                        if (!e1.operationInterrupted()) {
                            SVNUIPlugin.log((TeamException)((Object)e1));
                        }
                        svnRemoteResource.getRepository().returnSVNClient(client);
                    }
                    catch (SVNClientException e) {
                        SVNUIPlugin.log((TeamException)((Object)SVNException.wrapException((Exception)((Object)e))));
                        svnRemoteResource.getRepository().returnSVNClient(client);
                    }
                }
                finally {
                    svnRemoteResource.getRepository().returnSVNClient(client);
                }
            }
            return fetchedComment;
        }
    }
}

