/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.sync.SVNStatusSyncInfo;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.ShowOutOfDateFoldersAction;
import org.tigris.subversion.subclipse.ui.internal.ScopableSubscriberParticipant;
import org.tigris.subversion.subclipse.ui.subscriber.AddSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.CommitSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.EditConflictsSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.GenerateDiffFileSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.IgnoreSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.MarkMergedSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.OverrideAndUpdateSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.ResolveSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.RevertSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.SVNChangeSetCapability;
import org.tigris.subversion.subclipse.ui.subscriber.ShowHistorySynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.ShowPropertiesSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.UpdateSynchronizeAction;
import org.tigris.subversion.subclipse.ui.util.ResourceSelectionTreeDecorator;

public class SVNSynchronizeParticipant
extends ScopableSubscriberParticipant
implements IChangeSetProvider,
Preferences.IPropertyChangeListener {
    public static final String ID = "org.tigris.subversion.subclipse.participant";
    public static final String TOOLBAR_CONTRIBUTION_GROUP = "toolbar_group_1";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_1 = "context_group_1";
    public IResource[] resources;
    private ChangeSetCapability capability;

    public SVNSynchronizeParticipant() {
    }

    public SVNSynchronizeParticipant(ISynchronizeScope scope) {
        super(scope);
        this.setSubscriber((Subscriber)SVNWorkspaceSubscriber.getInstance());
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        this.setSubscriber((Subscriber)SVNWorkspaceSubscriber.getInstance());
        SVNProviderPlugin.getPlugin().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    @Override
    protected ISynchronizeParticipantDescriptor getDescriptor() {
        return TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        SVNParticipantLabelDecorator labelDecorator = new SVNParticipantLabelDecorator();
        configuration.addLabelDecorator((ILabelDecorator)labelDecorator);
        configuration.addMenuGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", TOOLBAR_CONTRIBUTION_GROUP);
        configuration.setSupportedModes(15);
        configuration.setMode(4);
        configuration.addActionContribution((SynchronizePageActionGroup)new SVNParticipantActionGroup());
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_1);
    }

    protected boolean isViewerContributionsSupported() {
        return true;
    }

    public ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = new SVNChangeSetCapability();
        }
        return this.capability;
    }

    public IStatus refresh(IResource[] resources, IProgressMonitor monitor) {
        this.resources = resources;
        return this.refreshNow(resources, this.getLongTaskName(resources), monitor);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event.getProperty().equals("ignore_hidden_changes") && this.getResources() != null) {
            this.refresh(this.getResources(), (IProgressMonitor)new NullProgressMonitor());
            this.reset();
        }
    }

    private class SVNParticipantActionGroup
    extends SynchronizePageActionGroup {
        Action expandAllAction;
        private UpdateSynchronizeAction updateToolbar;
        private CommitSynchronizeAction commitToolbar;

        private SVNParticipantActionGroup() {
        }

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.updateToolbar = new UpdateSynchronizeAction(null, configuration, this.getVisibleRootsSelectionProvider()){

                @Override
                protected FastSyncInfoFilter getSyncInfoFilter() {
                    return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 12});
                }
            };
            this.updateToolbar.setToolTipText(Policy.bind("SyncAction.updateAll"));
            this.updateToolbar.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/update_all.gif"));
            this.updateToolbar.setConfirm(true);
            this.commitToolbar = new CommitSynchronizeAction(null, configuration, this.getVisibleRootsSelectionProvider());
            this.commitToolbar.setToolTipText(Policy.bind("SyncAction.commitAll"));
            this.commitToolbar.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/commit_all.gif"));
            ShowOutOfDateFoldersAction showOutOfDateFoldersAction = SVNUIPlugin.getPlugin().getShowOutOfDateFoldersAction();
            showOutOfDateFoldersAction.setSvnSynchronizeParticipant(SVNSynchronizeParticipant.this);
            this.appendToGroup("org.eclipse.team.ui.P_VIEW_MENU", "modes", (IAction)showOutOfDateFoldersAction);
            UpdateSynchronizeAction updateAction = new UpdateSynchronizeAction(Policy.bind("SyncAction.update"), configuration);
            updateAction.setId("org.tigris.subversion.subclipse.ui.syncViewUpdate");
            updateAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.update");
            updateAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Update"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)updateAction);
            CommitSynchronizeAction commitAction = new CommitSynchronizeAction(Policy.bind("SyncAction.commit"), configuration);
            commitAction.setId("org.tigris.subversion.subclipse.ui.syncViewCommit");
            commitAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.commit");
            commitAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Commit"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)commitAction);
            GenerateDiffFileSynchronizeAction generateDiffFileAction = new GenerateDiffFileSynchronizeAction(Policy.bind("SyncAction.createPatch"), configuration);
            generateDiffFileAction.setId("org.tigris.subversion.subclipse.ui.syncViewCreatePatch");
            generateDiffFileAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.GenerateDiff");
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)generateDiffFileAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IContributionItem)new Separator());
            OverrideAndUpdateSynchronizeAction overrideAction = new OverrideAndUpdateSynchronizeAction(Policy.bind("SyncAction.override"), configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)overrideAction);
            MarkMergedSynchronizeAction markMergedAction = new MarkMergedSynchronizeAction(Policy.bind("SyncAction.markMerged"), configuration);
            markMergedAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Mark Merged"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)markMergedAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IContributionItem)new Separator());
            AddSynchronizeAction addAction = new AddSynchronizeAction(Policy.bind("SyncAction.add"), configuration);
            addAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Add"));
            addAction.setId("org.tigris.subversion.subclipse.ui.syncViewAdd");
            addAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.add");
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)addAction);
            IgnoreSynchronizeAction ignoreAction = new IgnoreSynchronizeAction(Policy.bind("SyncAction.ignore"), configuration);
            ignoreAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Ignore"));
            ignoreAction.setId("org.tigris.subversion.subclipse.ui.syncViewIgnore");
            ignoreAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.ignore");
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)ignoreAction);
            RevertSynchronizeAction revertAction = new RevertSynchronizeAction(Policy.bind("SyncAction.revert"), configuration);
            revertAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Revert"));
            revertAction.setId("org.tigris.subversion.subclipse.ui.syncViewRevert");
            revertAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.revert");
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)revertAction);
            ShowHistorySynchronizeAction historyAction = new ShowHistorySynchronizeAction(Policy.bind("SyncAction.history"), configuration);
            historyAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Show History"));
            historyAction.setId("org.tigris.subversion.subclipse.ui.syncViewShowResourceInHistoryAction");
            historyAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.showresourceinhistoryaction");
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)historyAction);
            ShowPropertiesSynchronizeAction propertiesAction = new ShowPropertiesSynchronizeAction(Policy.bind("SyncAction.properties"), configuration);
            propertiesAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Show Property"));
            propertiesAction.setId("org.tigris.subversion.subclipse.ui.syncViewShowSvnProperties");
            propertiesAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.showsvnproperties");
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)propertiesAction);
            EditConflictsSynchronizeAction conflictsAction = new EditConflictsSynchronizeAction(Policy.bind("SyncAction.conflicts"), configuration);
            conflictsAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Edit Conflicts"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)conflictsAction);
            ResolveSynchronizeAction resolveAction = new ResolveSynchronizeAction(Policy.bind("SyncAction.resolve"), configuration);
            resolveAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Resolve"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)resolveAction);
            final Viewer viewer = configuration.getPage().getViewer();
            if (viewer instanceof AbstractTreeViewer) {
                this.expandAllAction = new Action(null, SVNUIPlugin.getPlugin().getImageDescriptor("clcl16/expandall.gif")){

                    public void run() {
                        viewer.getControl().setRedraw(false);
                        ((AbstractTreeViewer)viewer).expandToLevel(viewer.getInput(), -1);
                        viewer.getControl().setRedraw(true);
                    }
                };
                this.expandAllAction.setToolTipText(Policy.bind("SyncAction.expandAllTooltip"));
                this.expandAllAction.setHoverImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("clcl16/expandall.gif"));
            }
        }

        public void fillActionBars(IActionBars actionBars) {
            IToolBarManager manager = actionBars.getToolBarManager();
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)this.expandAllAction);
            this.appendToGroup((IContributionManager)manager, SVNSynchronizeParticipant.TOOLBAR_CONTRIBUTION_GROUP, (IAction)this.updateToolbar);
            this.appendToGroup((IContributionManager)manager, SVNSynchronizeParticipant.TOOLBAR_CONTRIBUTION_GROUP, (IAction)this.commitToolbar);
        }
    }

    private class SVNParticipantLabelDecorator
    extends LabelProvider
    implements ILabelDecorator {
        ResourceSelectionTreeDecorator resourceDecorator = new ResourceSelectionTreeDecorator();

        private SVNParticipantLabelDecorator() {
        }

        public Image decorateImage(Image image, Object element) {
            if (element instanceof ISynchronizeModelElement) {
                IResource resource = ((ISynchronizeModelElement)element).getResource();
                if (resource == null) {
                    return null;
                }
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                try {
                    if (svnResource.getStatus().hasTreeConflict()) {
                        image = this.resourceDecorator.getImage(image, 4);
                    } else if (svnResource.getStatus().isTextConflicted()) {
                        image = this.resourceDecorator.getImage(image, 1);
                    } else {
                        svnResource.getStatus().isPropConflicted();
                    }
                }
                catch (SVNException sVNException) {}
            }
            return image;
        }

        public String decorateText(String text, Object element) {
            try {
                SVNStatusSyncInfo info;
                IResource resource;
                if (element instanceof ISynchronizeModelElement && (resource = ((ISynchronizeModelElement)element).getResource()) != null && (info = (SVNStatusSyncInfo)SVNWorkspaceSubscriber.getInstance().getSyncInfo(resource)) != null) {
                    return String.valueOf(text) + info.getLabel();
                }
            }
            catch (TeamException teamException) {}
            return null;
        }
    }
}

