/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.RelocateWizard;

public class RelocateWizardWarningPage
extends WizardPage {
    private IProject[] sharedProjects;
    private Table table;
    private TableViewer viewer;
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(100, 100, true)};
    private String[] columnHeaders = new String[]{"Project"};

    public RelocateWizardWarningPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        RelocateWizard wizard = (RelocateWizard)this.getWizard();
        this.sharedProjects = wizard.getSharedProjects();
        Composite outerContainer = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)outerContainer, "org.tigris.subversion.subclipse.ui.relocate_page_context");
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 2;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Label attentionImageLabel = new Label(outerContainer, 0);
        attentionImageLabel.setImage(SVNUIPlugin.getPlugin().getImageDescriptor("obj16/warn.gif").createImage());
        attentionImageLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        Text warningText = new Text(outerContainer, 64);
        warningText.setEditable(false);
        GridData data = new GridData(4, 128, true, false);
        data.widthHint = 400;
        data.heightHint = 40;
        warningText.setLayoutData((Object)data);
        warningText.setText(Policy.bind("RelocateWizard.warningMessage1"));
        warningText.setBackground(outerContainer.getBackground());
        Text warningText2 = new Text(outerContainer, 64);
        warningText2.setEditable(false);
        data = new GridData(4, 128, true, false, 2, 1);
        data.widthHint = 400;
        data.heightHint = 100;
        warningText2.setLayoutData((Object)data);
        warningText2.setText(Policy.bind("RelocateWizard.warningMessage2"));
        warningText2.setBackground(outerContainer.getBackground());
        Label projectsLabel = new Label(outerContainer, 0);
        projectsLabel.setText(Policy.bind("RelocateWizard.projects"));
        projectsLabel.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        this.table = new Table(outerContainer, 2048);
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(false);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        int i = 0;
        while (i < this.columnHeaders.length) {
            layout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.viewer.setInput((Object)this);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.widthHint = 400;
        gd.heightHint = 150;
        this.table.setLayoutData((Object)gd);
        this.setMessage(Policy.bind("RelocateWizard.warning"));
        this.setControl((Control)outerContainer);
    }

    class ProjectContentProvider
    implements IStructuredContentProvider {
        ProjectContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object arg0) {
            return RelocateWizardWarningPage.this.sharedProjects;
        }
    }

    class ProjectLabelProvider
    extends WorkbenchLabelProvider
    implements ITableLabelProvider {
        ProjectLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IProject project = (IProject)element;
            switch (columnIndex) {
                case 0: {
                    return project.getName();
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }
    }
}

