/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.wizards.ReplaceWithBranchTagWizardMainPage;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardSwitchPage;

public class ReplaceWithBranchTagWizard
extends Wizard {
    private IResource[] resources;
    private ReplaceWithBranchTagWizardMainPage mainPage;
    private SvnWizardSwitchPage switchPage;
    private boolean replaceContents;

    public ReplaceWithBranchTagWizard(IResource[] resources) {
        this.resources = resources;
        this.setWindowTitle(Policy.bind("ReplaceWithBranchTagWizard.0"));
    }

    public void addPages() {
        boolean showUrl = true;
        if (this.resources.length == 1 && !(this.resources[0] instanceof IProject)) {
            this.mainPage = new ReplaceWithBranchTagWizardMainPage(this.resources);
            this.addPage((IWizardPage)this.mainPage);
            showUrl = false;
        }
        this.switchPage = new SvnWizardSwitchPage(this.resources, showUrl);
        this.addPage((IWizardPage)this.switchPage);
    }

    public boolean performFinish() {
        boolean mainPageOk;
        this.replaceContents = this.mainPage == null ? false : this.mainPage.isReplace();
        if (this.mainPage != null && !(mainPageOk = this.mainPage.performFinish())) {
            return false;
        }
        if (!this.replaceContents) {
            return this.switchPage.performFinish();
        }
        return true;
    }

    public boolean isReplaceContents() {
        return this.replaceContents;
    }

    public boolean canFinish() {
        if (this.mainPage != null) {
            return this.mainPage.isPageComplete();
        }
        return this.switchPage.isPageComplete();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage && !this.mainPage.isReplace()) {
            return this.switchPage;
        }
        return null;
    }

    public ReplaceWithBranchTagWizardMainPage getMainPage() {
        return this.mainPage;
    }

    public SvnWizardSwitchPage getSwitchPage() {
        return this.switchPage;
    }
}

